/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.ni.kontrol.mki.controller;

import de.mossgrabers.controller.ni.kontrol.mki.controller.Kontrol1UsbDevice;
import de.mossgrabers.framework.controller.color.ColorEx;
import de.mossgrabers.framework.controller.color.ColorManager;
import de.mossgrabers.framework.controller.grid.LightGuideImpl;

public class Kontrol1LightGuide
extends LightGuideImpl {
    private final Kontrol1UsbDevice usbDevice;

    public Kontrol1LightGuide(ColorManager colorManager, Kontrol1UsbDevice usbDevice) {
        super(0, 128, colorManager, null);
        this.usbDevice = usbDevice;
    }

    @Override
    public int[] translateToController(int note) {
        int[] translated = super.translateToController(note);
        int firstNote = this.usbDevice.getFirstNote();
        translated[1] = note < firstNote || note >= firstNote + this.usbDevice.getNumKeys() ? -1 : note - firstNote;
        return translated;
    }

    @Override
    protected void sendNoteState(int channel, int note, int color) {
        if (note < 0 || note >= 88) {
            return;
        }
        ColorEx colorEx = this.colorManager.getColor(color, null);
        int[] rgb = colorEx.toIntRGB127();
        this.usbDevice.setKeyLED(note, rgb[0], rgb[1], rgb[2]);
    }
}

