/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.generic.flexihandler;

import de.mossgrabers.controller.generic.GenericFlexiConfiguration;
import de.mossgrabers.controller.generic.controller.FlexiCommand;
import de.mossgrabers.controller.generic.controller.GenericFlexiControlSurface;
import de.mossgrabers.controller.generic.flexihandler.AbstractHandler;
import de.mossgrabers.controller.generic.flexihandler.utils.FlexiHandlerException;
import de.mossgrabers.controller.generic.flexihandler.utils.KnobMode;
import de.mossgrabers.controller.generic.flexihandler.utils.MidiValue;
import de.mossgrabers.framework.controller.valuechanger.IValueChanger;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.constants.DeviceID;
import de.mossgrabers.framework.daw.data.EqualizerBandType;
import de.mossgrabers.framework.daw.data.ICursorTrack;
import de.mossgrabers.framework.daw.data.IEqualizerDevice;
import de.mossgrabers.framework.parameter.IParameter;

public class EqHandler
extends AbstractHandler {
    private boolean eqRequested = false;

    public EqHandler(IModel model, GenericFlexiControlSurface surface, GenericFlexiConfiguration configuration, IValueChanger absoluteLowResValueChanger, IValueChanger signedBitRelativeValueChanger, IValueChanger signedBit2RelativeValueChanger, IValueChanger offsetBinaryRelativeValueChanger) {
        super(model, surface, configuration, absoluteLowResValueChanger, signedBitRelativeValueChanger, signedBit2RelativeValueChanger, offsetBinaryRelativeValueChanger);
    }

    @Override
    public FlexiCommand[] getSupportedCommands() {
        return new FlexiCommand[]{FlexiCommand.EQ_SET_TYPE_1, FlexiCommand.EQ_SET_TYPE_2, FlexiCommand.EQ_SET_TYPE_3, FlexiCommand.EQ_SET_TYPE_4, FlexiCommand.EQ_SET_TYPE_5, FlexiCommand.EQ_SET_TYPE_6, FlexiCommand.EQ_SET_TYPE_7, FlexiCommand.EQ_SET_TYPE_8, FlexiCommand.EQ_SET_FREQ_1, FlexiCommand.EQ_SET_FREQ_2, FlexiCommand.EQ_SET_FREQ_3, FlexiCommand.EQ_SET_FREQ_4, FlexiCommand.EQ_SET_FREQ_5, FlexiCommand.EQ_SET_FREQ_6, FlexiCommand.EQ_SET_FREQ_7, FlexiCommand.EQ_SET_FREQ_8, FlexiCommand.EQ_SET_GAIN_1, FlexiCommand.EQ_SET_GAIN_2, FlexiCommand.EQ_SET_GAIN_3, FlexiCommand.EQ_SET_GAIN_4, FlexiCommand.EQ_SET_GAIN_5, FlexiCommand.EQ_SET_GAIN_6, FlexiCommand.EQ_SET_GAIN_7, FlexiCommand.EQ_SET_GAIN_8, FlexiCommand.EQ_SET_Q_1, FlexiCommand.EQ_SET_Q_2, FlexiCommand.EQ_SET_Q_3, FlexiCommand.EQ_SET_Q_4, FlexiCommand.EQ_SET_Q_5, FlexiCommand.EQ_SET_Q_6, FlexiCommand.EQ_SET_Q_7, FlexiCommand.EQ_SET_Q_8};
    }

    @Override
    public int getCommandValue(FlexiCommand command) {
        IEqualizerDevice equalizer = (IEqualizerDevice)this.model.getSpecificDevice(DeviceID.EQ);
        switch (command) {
            case EQ_SET_TYPE_1: 
            case EQ_SET_TYPE_2: 
            case EQ_SET_TYPE_3: 
            case EQ_SET_TYPE_4: 
            case EQ_SET_TYPE_5: 
            case EQ_SET_TYPE_6: 
            case EQ_SET_TYPE_7: 
            case EQ_SET_TYPE_8: {
                return equalizer.getTypeParameter(command.ordinal() - FlexiCommand.EQ_SET_TYPE_1.ordinal()).getValue();
            }
            case EQ_SET_FREQ_1: 
            case EQ_SET_FREQ_2: 
            case EQ_SET_FREQ_3: 
            case EQ_SET_FREQ_4: 
            case EQ_SET_FREQ_5: 
            case EQ_SET_FREQ_6: 
            case EQ_SET_FREQ_7: 
            case EQ_SET_FREQ_8: {
                return equalizer.getFrequencyParameter(command.ordinal() - FlexiCommand.EQ_SET_FREQ_1.ordinal()).getValue();
            }
            case EQ_SET_GAIN_1: 
            case EQ_SET_GAIN_2: 
            case EQ_SET_GAIN_3: 
            case EQ_SET_GAIN_4: 
            case EQ_SET_GAIN_5: 
            case EQ_SET_GAIN_6: 
            case EQ_SET_GAIN_7: 
            case EQ_SET_GAIN_8: {
                return equalizer.getGainParameter(command.ordinal() - FlexiCommand.EQ_SET_GAIN_1.ordinal()).getValue();
            }
            case EQ_SET_Q_1: 
            case EQ_SET_Q_2: 
            case EQ_SET_Q_3: 
            case EQ_SET_Q_4: 
            case EQ_SET_Q_5: 
            case EQ_SET_Q_6: 
            case EQ_SET_Q_7: 
            case EQ_SET_Q_8: {
                return equalizer.getQParameter(command.ordinal() - FlexiCommand.EQ_SET_Q_1.ordinal()).getValue();
            }
        }
        return -1;
    }

    @Override
    public void handle(FlexiCommand command, KnobMode knobMode, MidiValue value) {
        IEqualizerDevice equalizer = (IEqualizerDevice)this.model.getSpecificDevice(DeviceID.EQ);
        if (!equalizer.doesExist()) {
            ICursorTrack cursorTrack = this.model.getCursorTrack();
            if (cursorTrack.doesExist() && !this.eqRequested) {
                cursorTrack.addEqualizerDevice();
                this.eqRequested = true;
            }
            return;
        }
        this.eqRequested = false;
        switch (command) {
            case EQ_SET_TYPE_1: 
            case EQ_SET_TYPE_2: 
            case EQ_SET_TYPE_3: 
            case EQ_SET_TYPE_4: 
            case EQ_SET_TYPE_5: 
            case EQ_SET_TYPE_6: 
            case EQ_SET_TYPE_7: 
            case EQ_SET_TYPE_8: {
                int bandIndex1 = command.ordinal() - FlexiCommand.EQ_SET_TYPE_1.ordinal();
                IParameter type = equalizer.getTypeParameter(bandIndex1);
                this.handleParameter(knobMode, type, value);
                return;
            }
            case EQ_SET_FREQ_1: 
            case EQ_SET_FREQ_2: 
            case EQ_SET_FREQ_3: 
            case EQ_SET_FREQ_4: 
            case EQ_SET_FREQ_5: 
            case EQ_SET_FREQ_6: 
            case EQ_SET_FREQ_7: 
            case EQ_SET_FREQ_8: {
                int bandIndex2 = command.ordinal() - FlexiCommand.EQ_SET_FREQ_1.ordinal();
                EqHandler.ensureBandIsOn(equalizer, bandIndex2);
                IParameter frequency = equalizer.getFrequencyParameter(bandIndex2);
                this.handleParameter(knobMode, frequency, value);
                return;
            }
            case EQ_SET_GAIN_1: 
            case EQ_SET_GAIN_2: 
            case EQ_SET_GAIN_3: 
            case EQ_SET_GAIN_4: 
            case EQ_SET_GAIN_5: 
            case EQ_SET_GAIN_6: 
            case EQ_SET_GAIN_7: 
            case EQ_SET_GAIN_8: {
                int bandIndex3 = command.ordinal() - FlexiCommand.EQ_SET_GAIN_1.ordinal();
                EqHandler.ensureBandIsOn(equalizer, bandIndex3);
                IParameter gain = equalizer.getGainParameter(bandIndex3);
                this.handleParameter(knobMode, gain, value);
                return;
            }
            case EQ_SET_Q_1: 
            case EQ_SET_Q_2: 
            case EQ_SET_Q_3: 
            case EQ_SET_Q_4: 
            case EQ_SET_Q_5: 
            case EQ_SET_Q_6: 
            case EQ_SET_Q_7: 
            case EQ_SET_Q_8: {
                int bandIndex4 = command.ordinal() - FlexiCommand.EQ_SET_Q_1.ordinal();
                EqHandler.ensureBandIsOn(equalizer, bandIndex4);
                IParameter q = equalizer.getQParameter(bandIndex4);
                this.handleParameter(knobMode, q, value);
                return;
            }
        }
        throw new FlexiHandlerException(command);
    }

    private static void ensureBandIsOn(IEqualizerDevice equalizer, int bandIndex) {
        if (equalizer.getTypeID(bandIndex) == EqualizerBandType.OFF) {
            equalizer.setType(bandIndex, EqualizerBandType.BELL);
        }
    }

    private void handleParameter(KnobMode knobMode, IParameter fxParam, MidiValue value) {
        int val = value.getValue();
        if (EqHandler.isAbsolute(knobMode)) {
            fxParam.setValue(this.getAbsoluteValueChanger(value), val);
        } else {
            fxParam.changeValue(this.getRelativeValueChanger(knobMode), val);
        }
        this.mvHelper.notifyParameter(fxParam);
    }
}

