/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.akai.fire.view;

import de.mossgrabers.controller.akai.fire.FireConfiguration;
import de.mossgrabers.controller.akai.fire.controller.FireControlSurface;
import de.mossgrabers.controller.akai.fire.controller.FirePadGrid;
import de.mossgrabers.controller.akai.fire.view.IFireView;
import de.mossgrabers.framework.controller.ButtonID;
import de.mossgrabers.framework.daw.DAWColor;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.ITransport;
import de.mossgrabers.framework.daw.data.ITrack;
import de.mossgrabers.framework.daw.data.bank.ITrackBank;
import de.mossgrabers.framework.featuregroup.AbstractView;
import de.mossgrabers.framework.utils.ButtonEvent;

public class MixView
extends AbstractView<FireControlSurface, FireConfiguration>
implements IFireView {
    public MixView(FireControlSurface surface, IModel model) {
        super("Mix", surface, model);
    }

    @Override
    public void drawGrid() {
        FirePadGrid padGrid = ((FireControlSurface)this.surface).getPadGrid();
        boolean colorTrackStates = ((FireConfiguration)((FireControlSurface)this.surface).getConfiguration()).isColorTrackStates();
        ITrackBank tb = this.model.getCurrentTrackBank();
        for (int i = 0; i < tb.getPageSize(); ++i) {
            ITrack track = (ITrack)tb.getItem(i);
            if (track.doesExist()) {
                int colorIndex = this.colorManager.getColorIndex(DAWColor.getColorID(track.getColor()));
                if (track.isSelected()) {
                    padGrid.lightEx(i, 0, colorIndex, 59, false);
                } else {
                    padGrid.lightEx(i, 0, colorIndex);
                }
                padGrid.lightEx(i, 1, MixView.getTrackStateColor(track.isMute(), colorTrackStates, 68, 70));
                padGrid.lightEx(i, 2, MixView.getTrackStateColor(track.isSolo(), colorTrackStates, 71, 73));
                padGrid.lightEx(i, 3, MixView.getTrackStateColor(track.isRecArm(), colorTrackStates, 62, 64));
                continue;
            }
            padGrid.lightEx(i, 3, 0);
            padGrid.lightEx(i, 2, 0);
            padGrid.lightEx(i, 1, 0);
            padGrid.lightEx(i, 0, 0);
        }
    }

    @Override
    public void onGridNote(int note, int velocity) {
        if (velocity == 0) {
            return;
        }
        int n = note - 36;
        int index = n % 16;
        int what = n / 16;
        ITrack track = (ITrack)this.model.getCurrentTrackBank().getItem(index);
        switch (what) {
            case 3: {
                FireConfiguration configuration = (FireConfiguration)((FireControlSurface)this.surface).getConfiguration();
                if (configuration.isDeleteModeActive()) {
                    configuration.toggleDeleteModeActive();
                    track.remove();
                    break;
                }
                if (configuration.isDuplicateModeActive()) {
                    configuration.toggleDuplicateModeActive();
                    track.duplicate();
                    break;
                }
                track.selectOrExpandGroup();
                break;
            }
            case 2: {
                track.toggleMute();
                break;
            }
            case 1: {
                track.toggleSolo();
                break;
            }
            case 0: {
                track.toggleRecArm();
                break;
            }
        }
    }

    @Override
    public int getSoloButtonColor(int index) {
        switch (index) {
            case 1: {
                return this.model.getProject().hasMute() ? 3 : 0;
            }
            case 2: {
                return this.model.getProject().hasSolo() ? 4 : 0;
            }
        }
        return 0;
    }

    @Override
    public int getButtonColor(ButtonID buttonID) {
        switch (buttonID) {
            case SCENE1: 
            case SCENE4: {
                return 0;
            }
            case SCENE2: 
            case SCENE3: {
                return ((FireControlSurface)this.surface).isPressed(buttonID) ? 2 : 1;
            }
        }
        return super.getButtonColor(buttonID);
    }

    @Override
    public void onButton(ButtonID buttonID, ButtonEvent event, int velocity) {
        if (event != ButtonEvent.DOWN) {
            return;
        }
        switch (buttonID) {
            case ARROW_LEFT: {
                this.model.getCurrentTrackBank().selectPreviousPage();
                break;
            }
            case ARROW_RIGHT: {
                this.model.getCurrentTrackBank().selectNextPage();
                break;
            }
            case SCENE1: {
                this.model.getTransport().selectLoopStart();
                break;
            }
            case SCENE2: {
                this.model.getProject().clearMute();
                break;
            }
            case SCENE3: {
                this.model.getProject().clearSolo();
                break;
            }
            case SCENE4: {
                this.model.getTransport().selectLoopEnd();
                break;
            }
        }
    }

    @Override
    public void onSelectKnobValue(int value) {
        ITransport transport = this.model.getTransport();
        transport.changePosition(this.model.getValueChanger().isIncrease(value), ((FireControlSurface)this.surface).isPressed(ButtonID.SHIFT));
        this.mvHelper.notifyPlayPosition();
    }

    private static int getTrackStateColor(boolean state, boolean colorTrackStates, int activeColor, int inActiveColor) {
        if (state) {
            return activeColor;
        }
        return colorTrackStates ? inActiveColor : 0;
    }
}

