/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.ableton.push.mode;

import de.mossgrabers.controller.ableton.push.PushConfiguration;
import de.mossgrabers.controller.ableton.push.controller.Push1Display;
import de.mossgrabers.controller.ableton.push.controller.PushControlSurface;
import de.mossgrabers.controller.ableton.push.mode.BaseMode;
import de.mossgrabers.framework.command.trigger.clip.TemporaryNewCommand;
import de.mossgrabers.framework.configuration.AbstractConfiguration;
import de.mossgrabers.framework.controller.ButtonID;
import de.mossgrabers.framework.controller.display.IGraphicDisplay;
import de.mossgrabers.framework.controller.display.ITextDisplay;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.data.IItem;
import de.mossgrabers.framework.utils.ButtonEvent;

public class FixedMode
extends BaseMode<IItem> {
    private final TemporaryNewCommand<?, ?>[] newCommands = new TemporaryNewCommand[8];

    public FixedMode(PushControlSurface surface, IModel model) {
        super("Fixed", surface, model);
        for (int i = 0; i < 8; ++i) {
            this.newCommands[i] = new TemporaryNewCommand(i, this.model, (PushControlSurface)this.surface);
        }
    }

    @Override
    public void onFirstRow(int index, ButtonEvent event) {
        if (event != ButtonEvent.UP) {
            return;
        }
        ((PushConfiguration)((PushControlSurface)this.surface).getConfiguration()).setNewClipLength(index);
        ((PushControlSurface)this.surface).getModeManager().restore();
    }

    @Override
    public void onSecondRow(int index, ButtonEvent event) {
        if (event != ButtonEvent.UP) {
            return;
        }
        this.newCommands[index].execute();
        ((PushControlSurface)this.surface).getModeManager().restore();
    }

    @Override
    public int getButtonColor(ButtonID buttonID) {
        int index = this.isButtonRow(0, buttonID);
        if (index >= 0) {
            Object configuration = ((PushControlSurface)this.surface).getConfiguration();
            return this.colorManager.getColorIndex(configuration.getNewClipLength() == index ? "BUTTON_COLOR_HI" : "BUTTON_COLOR_ON");
        }
        return this.colorManager.getColorIndex("BUTTON_COLOR_ON");
    }

    @Override
    public void updateDisplay1(ITextDisplay display) {
        display.setBlock(1, 0, "Create Clip (leng").setBlock(1, 1, "th not stored):");
        int newClipLength = ((PushConfiguration)((PushControlSurface)this.surface).getConfiguration()).getNewClipLength();
        display.setBlock(2, 0, "New Clip Length:");
        for (int i = 0; i < 8; ++i) {
            String newClipLengthValue = AbstractConfiguration.getNewClipLengthValue(i);
            display.setCell(0, i, newClipLengthValue);
            display.setCell(3, i, (newClipLength == i ? Push1Display.SELECT_ARROW : "") + newClipLengthValue);
        }
    }

    @Override
    public void updateDisplay2(IGraphicDisplay display) {
        int newClipLength = ((PushConfiguration)((PushControlSurface)this.surface).getConfiguration()).getNewClipLength();
        for (int i = 0; i < 8; ++i) {
            String newClipLengthValue = AbstractConfiguration.getNewClipLengthValue(i);
            display.addOptionElement(i == 0 ? "Create Clip (length not stored)" : "", newClipLengthValue, false, i == 0 ? "New Clip Length" : "", newClipLengthValue, newClipLength == i, false);
        }
    }
}

