/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.reaper.ui.dialog;

import de.mossgrabers.framework.controller.IControllerDefinition;
import de.mossgrabers.reaper.controller.IControllerInstance;
import de.mossgrabers.reaper.framework.configuration.DocumentSettingsUI;
import de.mossgrabers.reaper.framework.configuration.IfxSetting;
import de.mossgrabers.reaper.ui.dialog.BasicDialog;
import de.mossgrabers.reaper.ui.widget.BoxPanel;
import de.mossgrabers.reaper.ui.widget.Functions;
import de.mossgrabers.reaper.ui.widget.TitledSeparator;
import de.mossgrabers.reaper.ui.widget.TwoColsPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;

public class ProjectSettingsDialog
extends BasicDialog {
    private static final long serialVersionUID = 7245426678995058875L;
    private final transient List<IControllerInstance> instances;

    public ProjectSettingsDialog(Window owner, List<IControllerInstance> instances) {
        super((JFrame)owner, "Project Settings", true, true);
        this.setMinimumSize(new Dimension(600, 600));
        this.setSize(600, 600);
        this.instances = instances;
        this.basicInit();
    }

    @Override
    protected Container init() {
        JPanel contentPane = new JPanel(new BorderLayout());
        JTabbedPane tabbedPane = new JTabbedPane();
        contentPane.add((Component)tabbedPane, "Center");
        for (IControllerInstance instance : this.instances) {
            if (!instance.isRunning()) continue;
            ProjectSettingsDialog.createDocumentSettings(instance, tabbedPane);
        }
        BoxPanel buttons = new BoxPanel(0, true);
        buttons.createSpace(-1);
        this.setButtons(null, buttons.createButton(Functions.getIcon("Confirm"), "Close", null, 0));
        contentPane.add((Component)buttons, "South");
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent event) {
                Rectangle b = ProjectSettingsDialog.this.getBounds();
                Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
                int maxHeight = (int)screenSize.getHeight() - 200;
                if (b.height > maxHeight) {
                    b.height = maxHeight;
                    ProjectSettingsDialog.this.setBounds(b);
                }
                super.componentResized(event);
            }
        });
        return contentPane;
    }

    private static void createDocumentSettings(IControllerInstance instance, JTabbedPane tabbedPane) {
        JPanel tabContentPane = new JPanel(new BorderLayout());
        IControllerDefinition definition = instance.getDefinition();
        tabbedPane.addTab(definition.getHardwareModel(), tabContentPane);
        TwoColsPanel mainColumn = new TwoColsPanel(true);
        JPanel wrapper = new JPanel(new BorderLayout());
        wrapper.add((Component)mainColumn, "North");
        JScrollPane scrollPane = new JScrollPane(wrapper);
        scrollPane.setHorizontalScrollBarPolicy(31);
        scrollPane.setVerticalScrollBarPolicy(22);
        tabContentPane.add((Component)scrollPane, "Center");
        String category = null;
        DocumentSettingsUI settings = instance.getDocumentSettingsUI();
        List<IfxSetting> ifxSettings = settings.getSettings();
        if (ifxSettings.isEmpty()) {
            mainColumn.add(new JLabel("This device has no project settings."));
            return;
        }
        for (IfxSetting s : ifxSettings) {
            String cat = s.getCategory();
            if (category == null || !category.equals(cat)) {
                category = s.getCategory();
                mainColumn.addComponent(new TitledSeparator(category), 12);
            }
            JLabel label = s.getLabelWidget();
            JComponent widget = s.getWidget();
            mainColumn.addComponent(widget, label, null, 12);
        }
    }
}

