/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.reaper.framework.hardware;

import de.mossgrabers.framework.controller.color.ColorEx;
import de.mossgrabers.framework.controller.hardware.AbstractHwControl;
import de.mossgrabers.framework.controller.hardware.IHwLight;
import de.mossgrabers.framework.graphics.IGraphicsContext;
import de.mossgrabers.reaper.framework.hardware.Bounds;
import de.mossgrabers.reaper.framework.hardware.HwControlLayout;
import de.mossgrabers.reaper.framework.hardware.IReaperHwControl;
import java.util.function.Consumer;
import java.util.function.IntConsumer;
import java.util.function.IntFunction;
import java.util.function.IntSupplier;
import java.util.function.Supplier;

public class HwLightImpl
extends AbstractHwControl
implements IHwLight,
IReaperHwControl {
    private final HwControlLayout layout;
    private final Supplier<ColorEx> colorSupplier;
    private final Consumer<ColorEx> colorSendValueConsumer;
    private final IntSupplier intSupplier;
    private final IntConsumer intSendValueConsumer;
    private IntFunction<ColorEx> stateToColorFunction;
    private ColorEx colorState;
    private int intState;
    private ColorEx blinkColorEx;
    private double blinkTimeInSec;

    public HwLightImpl(String id, Supplier<ColorEx> supplier, Consumer<ColorEx> sendValueConsumer) {
        super(null, null);
        this.layout = new HwControlLayout(id);
        this.colorSupplier = supplier;
        this.colorSendValueConsumer = sendValueConsumer;
        this.intSupplier = null;
        this.intSendValueConsumer = null;
    }

    public HwLightImpl(String id, IntSupplier supplier, IntConsumer sendValueConsumer, IntFunction<ColorEx> stateToColorFunction) {
        super(null, null);
        this.layout = new HwControlLayout(id);
        this.colorSupplier = null;
        this.colorSendValueConsumer = null;
        this.intSupplier = supplier;
        this.intSendValueConsumer = sendValueConsumer;
        this.stateToColorFunction = stateToColorFunction;
    }

    @Override
    public void forceFlush() {
        this.colorState = null;
        this.intState = -1;
    }

    @Override
    public void turnOff() {
        if (this.colorSendValueConsumer != null) {
            this.colorSendValueConsumer.accept(ColorEx.BLACK);
        } else {
            this.intSendValueConsumer.accept(0);
        }
    }

    @Override
    public void update() {
        if (this.colorSupplier != null) {
            ColorEx newColorState = this.colorSupplier.get();
            if (this.colorState != null && this.colorState.equals(newColorState)) {
                return;
            }
            this.colorState = newColorState;
            this.colorSendValueConsumer.accept(this.colorState);
            return;
        }
        int newColorState = this.intSupplier.getAsInt();
        if (this.intState == newColorState) {
            return;
        }
        this.intState = newColorState;
        this.intSendValueConsumer.accept(this.intState);
        if (this.intState == -1) {
            this.colorState = null;
            return;
        }
        int colorIndex = this.intState & 0xFF;
        int blinkColorIndex = this.intState >> 8 & 0xFF;
        boolean blinkFast = (this.intState >> 16 & 1) > 0;
        this.colorState = this.stateToColorFunction.apply(colorIndex);
        if (blinkColorIndex <= 0 || blinkColorIndex >= 128) {
            this.blinkColorEx = null;
        } else {
            this.blinkColorEx = this.stateToColorFunction.apply(blinkColorIndex);
            this.blinkTimeInSec = blinkFast ? 0.5 : 1.0;
        }
    }

    @Override
    public void setBounds(double x, double y, double width, double height) {
        this.layout.setBounds(x, y, width, height);
    }

    @Override
    public void draw(IGraphicsContext gc, double scale) {
        ColorEx color;
        Bounds bounds = this.layout.getBounds();
        if (bounds == null) {
            return;
        }
        ColorEx colorEx = color = this.colorState == null ? ColorEx.BLACK : this.colorState;
        if (this.colorState != null && this.blinkColorEx != null) {
            long rate = Math.round(this.blinkTimeInSec * 2.0);
            long seconds = System.currentTimeMillis() / 1000L;
            if (seconds % (rate + 1L) == rate) {
                color = this.blinkColorEx;
            }
        }
        gc.fillRectangle(bounds.x() * scale, bounds.y() * scale, bounds.width() * scale, bounds.height() * scale, color);
        gc.strokeRectangle(bounds.x() * scale, bounds.y() * scale, bounds.width() * scale, bounds.height() * scale, ColorEx.BLACK);
    }

    public ColorEx getColorState() {
        return this.colorState;
    }

    @Override
    public void mouse(int mouseEvent, double x, double y, double scale) {
    }
}

