/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.reaper.framework.daw.data;

import de.mossgrabers.framework.controller.color.ColorEx;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.constants.RecordQuantization;
import de.mossgrabers.framework.daw.data.ICursorTrack;
import de.mossgrabers.framework.daw.data.IDeviceMetadata;
import de.mossgrabers.framework.daw.data.IMasterTrack;
import de.mossgrabers.framework.daw.data.ITrack;
import de.mossgrabers.framework.daw.data.bank.IParameterBank;
import de.mossgrabers.framework.daw.data.bank.ISendBank;
import de.mossgrabers.framework.daw.data.bank.ISlotBank;
import de.mossgrabers.framework.daw.data.bank.ITrackBank;
import de.mossgrabers.framework.daw.data.empty.EmptyParameter;
import de.mossgrabers.framework.daw.data.empty.EmptySendBank;
import de.mossgrabers.framework.daw.data.empty.EmptySlotBank;
import de.mossgrabers.framework.daw.resource.ChannelType;
import de.mossgrabers.framework.observer.IValueObserver;
import de.mossgrabers.framework.parameter.IParameter;
import de.mossgrabers.reaper.framework.daw.data.ChannelImpl;
import de.mossgrabers.reaper.framework.daw.data.bank.ParameterBankDelegator;
import java.util.Optional;

public class CursorTrackImpl
implements ICursorTrack {
    private final IModel model;
    private final ParameterBankDelegator parameterBankDelegator;
    private boolean isGroupExpanded = true;
    private boolean isPinned = false;
    private ITrack pinnedTrack = null;
    private final int numSends;
    private final int numSlots;

    public CursorTrackImpl(IModel model, int numParams, int numSends, int numSlots) {
        this.model = model;
        this.numSends = numSends;
        this.numSlots = numSlots;
        this.parameterBankDelegator = new ParameterBankDelegator(this, numParams);
    }

    @Override
    public IParameter getCrossfadeParameter() {
        ITrack selectedTrack = this.getPinnedOrSelectedTrack();
        return selectedTrack != null ? selectedTrack.getCrossfadeParameter() : EmptyParameter.INSTANCE;
    }

    @Override
    public boolean isGroup() {
        ITrack selectedTrack = this.getPinnedOrSelectedTrack();
        return selectedTrack != null && selectedTrack.isGroup();
    }

    @Override
    public boolean isGroupExpanded() {
        return this.isGroupExpanded;
    }

    public void setIsGroupExpanded(boolean isGroupExpanded) {
        this.isGroupExpanded = isGroupExpanded;
    }

    @Override
    public void setGroupExpanded(boolean isExpanded) {
        this.isGroupExpanded = isExpanded;
        this.sendPositionedItemOSC("isGroupExpanded", this.isGroupExpanded);
    }

    @Override
    public void toggleGroupExpanded() {
        this.setGroupExpanded(!this.isGroupExpanded);
    }

    @Override
    public boolean hasParent() {
        ITrack selectedTrack = this.getPinnedOrSelectedTrack();
        return selectedTrack != null && selectedTrack.hasParent();
    }

    @Override
    public boolean isRecArm() {
        ITrack selectedTrack = this.getPinnedOrSelectedTrack();
        return selectedTrack != null && selectedTrack.isRecArm();
    }

    @Override
    public void setRecArm(boolean value) {
        ITrack selectedTrack = this.getPinnedOrSelectedTrack();
        if (selectedTrack != null) {
            selectedTrack.setRecArm(value);
        }
    }

    @Override
    public void toggleRecArm() {
        ITrack selectedTrack = this.getPinnedOrSelectedTrack();
        if (selectedTrack != null) {
            selectedTrack.toggleRecArm();
        }
    }

    @Override
    public boolean isMonitor() {
        ITrack selectedTrack = this.getPinnedOrSelectedTrack();
        return selectedTrack != null && selectedTrack.isMonitor();
    }

    @Override
    public void setMonitor(boolean value) {
        ITrack selectedTrack = this.getPinnedOrSelectedTrack();
        if (selectedTrack != null) {
            selectedTrack.setMonitor(value);
        }
    }

    @Override
    public void toggleMonitor() {
        ITrack selectedTrack = this.getPinnedOrSelectedTrack();
        if (selectedTrack != null) {
            selectedTrack.toggleMonitor();
        }
    }

    @Override
    public boolean isAutoMonitor() {
        ITrack selectedTrack = this.getPinnedOrSelectedTrack();
        return selectedTrack != null && selectedTrack.isAutoMonitor();
    }

    @Override
    public void setAutoMonitor(boolean value) {
        ITrack selectedTrack = this.getPinnedOrSelectedTrack();
        if (selectedTrack != null) {
            selectedTrack.setAutoMonitor(value);
        }
    }

    @Override
    public void toggleAutoMonitor() {
        ITrack selectedTrack = this.getPinnedOrSelectedTrack();
        if (selectedTrack != null) {
            selectedTrack.toggleAutoMonitor();
        }
    }

    @Override
    public boolean canHoldNotes() {
        ITrack selectedTrack = this.getPinnedOrSelectedTrack();
        return selectedTrack != null && selectedTrack.canHoldNotes();
    }

    @Override
    public boolean canHoldAudioData() {
        ITrack selectedTrack = this.getPinnedOrSelectedTrack();
        return selectedTrack != null && selectedTrack.canHoldAudioData();
    }

    @Override
    public ISlotBank getSlotBank() {
        ITrack selectedTrack = this.getPinnedOrSelectedTrack();
        return selectedTrack != null ? selectedTrack.getSlotBank() : EmptySlotBank.getInstance(this.numSlots);
    }

    @Override
    public void createClip(int slotIndex, int lengthInBeats) {
        ITrack selectedTrack = this.getPinnedOrSelectedTrack();
        if (selectedTrack != null) {
            selectedTrack.createClip(slotIndex, lengthInBeats);
        }
    }

    @Override
    public boolean isPlaying() {
        ITrack selectedTrack = this.getPinnedOrSelectedTrack();
        return selectedTrack != null && selectedTrack.isPlaying();
    }

    @Override
    public void stop(boolean isAlternative) {
        ITrack selectedTrack = this.getPinnedOrSelectedTrack();
        if (selectedTrack != null) {
            selectedTrack.stop(isAlternative);
        }
    }

    @Override
    public void returnToArrangement() {
        ITrack selectedTrack = this.getPinnedOrSelectedTrack();
        if (selectedTrack != null) {
            selectedTrack.returnToArrangement();
        }
    }

    @Override
    public boolean isRecordQuantizationNoteLength() {
        ITrack selectedTrack = this.getPinnedOrSelectedTrack();
        return selectedTrack != null && selectedTrack.isRecordQuantizationNoteLength();
    }

    @Override
    public void toggleRecordQuantizationNoteLength() {
        ITrack selectedTrack = this.getPinnedOrSelectedTrack();
        if (selectedTrack != null) {
            selectedTrack.toggleRecordQuantizationNoteLength();
        }
    }

    @Override
    public RecordQuantization getRecordQuantizationGrid() {
        ITrack selectedTrack = this.getPinnedOrSelectedTrack();
        return selectedTrack != null ? selectedTrack.getRecordQuantizationGrid() : RecordQuantization.RES_OFF;
    }

    @Override
    public void setRecordQuantizationGrid(RecordQuantization recordQuantization) {
        ITrack selectedTrack = this.getPinnedOrSelectedTrack();
        if (selectedTrack != null) {
            selectedTrack.setRecordQuantizationGrid(recordQuantization);
        }
    }

    @Override
    public void addEqualizerDevice() {
        ITrack selectedTrack = this.getPinnedOrSelectedTrack();
        if (selectedTrack != null) {
            selectedTrack.addEqualizerDevice();
        }
    }

    @Override
    public boolean isActivated() {
        ITrack selectedTrack = this.getPinnedOrSelectedTrack();
        return selectedTrack != null && selectedTrack.isActivated();
    }

    @Override
    public ChannelType getType() {
        ITrack selectedTrack = this.getPinnedOrSelectedTrack();
        return selectedTrack != null ? selectedTrack.getType() : ChannelType.UNKNOWN;
    }

    @Override
    public IParameter getVolumeParameter() {
        ITrack selectedTrack = this.getPinnedOrSelectedTrack();
        return selectedTrack != null ? selectedTrack.getVolumeParameter() : EmptyParameter.INSTANCE;
    }

    @Override
    public String getVolumeStr() {
        ITrack selectedTrack = this.getPinnedOrSelectedTrack();
        return selectedTrack != null ? selectedTrack.getVolumeStr() : "";
    }

    @Override
    public String getVolumeStr(int limit) {
        ITrack selectedTrack = this.getPinnedOrSelectedTrack();
        return selectedTrack != null ? selectedTrack.getVolumeStr(limit) : "";
    }

    @Override
    public int getVolume() {
        ITrack selectedTrack = this.getPinnedOrSelectedTrack();
        return selectedTrack != null ? selectedTrack.getVolume() : 0;
    }

    @Override
    public void changeVolume(int control) {
        ITrack selectedTrack = this.getPinnedOrSelectedTrack();
        if (selectedTrack != null) {
            selectedTrack.changeVolume(control);
        }
    }

    @Override
    public void setVolume(int value) {
        ITrack selectedTrack = this.getPinnedOrSelectedTrack();
        if (selectedTrack != null) {
            selectedTrack.setVolume(value);
        }
    }

    @Override
    public void resetVolume() {
        ITrack selectedTrack = this.getPinnedOrSelectedTrack();
        if (selectedTrack != null) {
            selectedTrack.resetVolume();
        }
    }

    @Override
    public void touchVolume(boolean isBeingTouched) {
        ITrack selectedTrack = this.getPinnedOrSelectedTrack();
        if (selectedTrack != null) {
            selectedTrack.touchVolume(isBeingTouched);
        }
    }

    @Override
    public void setVolumeIndication(boolean indicate) {
        ITrack selectedTrack = this.getPinnedOrSelectedTrack();
        if (selectedTrack != null) {
            selectedTrack.setVolumeIndication(indicate);
        }
    }

    @Override
    public int getModulatedVolume() {
        ITrack selectedTrack = this.getPinnedOrSelectedTrack();
        return selectedTrack != null ? selectedTrack.getModulatedVolume() : 0;
    }

    @Override
    public IParameter getPanParameter() {
        ITrack selectedTrack = this.getPinnedOrSelectedTrack();
        return selectedTrack != null ? selectedTrack.getPanParameter() : EmptyParameter.INSTANCE;
    }

    @Override
    public String getPanStr() {
        ITrack selectedTrack = this.getPinnedOrSelectedTrack();
        return selectedTrack != null ? selectedTrack.getPanStr() : "";
    }

    @Override
    public String getPanStr(int limit) {
        ITrack selectedTrack = this.getPinnedOrSelectedTrack();
        return selectedTrack != null ? selectedTrack.getPanStr(limit) : "";
    }

    @Override
    public int getPan() {
        ITrack selectedTrack = this.getPinnedOrSelectedTrack();
        return selectedTrack != null ? selectedTrack.getPan() : 0;
    }

    @Override
    public void changePan(int control) {
        ITrack selectedTrack = this.getPinnedOrSelectedTrack();
        if (selectedTrack != null) {
            selectedTrack.changePan(control);
        }
    }

    @Override
    public void setPan(int value) {
        ITrack selectedTrack = this.getPinnedOrSelectedTrack();
        if (selectedTrack != null) {
            selectedTrack.setPan(value);
        }
    }

    @Override
    public void resetPan() {
        ITrack selectedTrack = this.getPinnedOrSelectedTrack();
        if (selectedTrack != null) {
            selectedTrack.resetPan();
        }
    }

    @Override
    public void touchPan(boolean isBeingTouched) {
        ITrack selectedTrack = this.getPinnedOrSelectedTrack();
        if (selectedTrack != null) {
            selectedTrack.touchPan(isBeingTouched);
        }
    }

    @Override
    public void setPanIndication(boolean indicate) {
        ITrack selectedTrack = this.getPinnedOrSelectedTrack();
        if (selectedTrack != null) {
            selectedTrack.setPanIndication(indicate);
        }
    }

    @Override
    public int getModulatedPan() {
        ITrack selectedTrack = this.getPinnedOrSelectedTrack();
        return selectedTrack != null ? selectedTrack.getModulatedPan() : 0;
    }

    @Override
    public void setIsActivated(boolean value) {
        ITrack selectedTrack = this.getPinnedOrSelectedTrack();
        if (selectedTrack != null) {
            selectedTrack.setIsActivated(value);
        }
    }

    @Override
    public void toggleIsActivated() {
        ITrack selectedTrack = this.getPinnedOrSelectedTrack();
        if (selectedTrack != null) {
            selectedTrack.toggleIsActivated();
        }
    }

    @Override
    public ColorEx getColor() {
        ITrack selectedTrack = this.getPinnedOrSelectedTrack();
        return selectedTrack != null ? selectedTrack.getColor() : ColorEx.BLACK;
    }

    @Override
    public void setColor(ColorEx color) {
        ITrack selectedTrack = this.getPinnedOrSelectedTrack();
        if (selectedTrack != null) {
            selectedTrack.setColor(color);
        }
    }

    @Override
    public IParameter getMuteParameter() {
        ITrack selectedTrack = this.getPinnedOrSelectedTrack();
        return selectedTrack != null ? selectedTrack.getMuteParameter() : EmptyParameter.INSTANCE;
    }

    @Override
    public boolean isMute() {
        ITrack selectedTrack = this.getPinnedOrSelectedTrack();
        return selectedTrack != null && selectedTrack.isMute();
    }

    @Override
    public void setMute(boolean value) {
        ITrack selectedTrack = this.getPinnedOrSelectedTrack();
        if (selectedTrack != null) {
            selectedTrack.setMute(value);
        }
    }

    @Override
    public void toggleMute() {
        ITrack selectedTrack = this.getPinnedOrSelectedTrack();
        if (selectedTrack != null) {
            selectedTrack.toggleMute();
        }
    }

    @Override
    public IParameter getSoloParameter() {
        ITrack selectedTrack = this.getPinnedOrSelectedTrack();
        return selectedTrack != null ? selectedTrack.getSoloParameter() : EmptyParameter.INSTANCE;
    }

    @Override
    public boolean isSolo() {
        ITrack selectedTrack = this.getPinnedOrSelectedTrack();
        return selectedTrack != null && selectedTrack.isSolo();
    }

    @Override
    public void setSolo(boolean value) {
        ITrack selectedTrack = this.getPinnedOrSelectedTrack();
        if (selectedTrack != null) {
            selectedTrack.setSolo(value);
        }
    }

    @Override
    public void toggleSolo() {
        ITrack selectedTrack = this.getPinnedOrSelectedTrack();
        if (selectedTrack != null) {
            selectedTrack.toggleSolo();
        }
    }

    @Override
    public boolean isMutedBySolo() {
        ITrack selectedTrack = this.getPinnedOrSelectedTrack();
        return selectedTrack != null && selectedTrack.isMutedBySolo();
    }

    @Override
    public int getVu() {
        ITrack selectedTrack = this.getPinnedOrSelectedTrack();
        return selectedTrack != null ? selectedTrack.getVu() : 0;
    }

    @Override
    public int getVuLeft() {
        ITrack selectedTrack = this.getPinnedOrSelectedTrack();
        return selectedTrack != null ? selectedTrack.getVuLeft() : 0;
    }

    @Override
    public int getVuRight() {
        ITrack selectedTrack = this.getPinnedOrSelectedTrack();
        return selectedTrack != null ? selectedTrack.getVuRight() : 0;
    }

    @Override
    public int getVuPeakLeft() {
        ITrack selectedTrack = this.getPinnedOrSelectedTrack();
        return selectedTrack != null ? selectedTrack.getVuPeakLeft() : 0;
    }

    @Override
    public int getVuPeakRight() {
        ITrack selectedTrack = this.getPinnedOrSelectedTrack();
        return selectedTrack != null ? selectedTrack.getVuPeakRight() : 0;
    }

    @Override
    public boolean getVuClipState() {
        ITrack selectedTrack = this.getPinnedOrSelectedTrack();
        return selectedTrack != null && selectedTrack.getVuClipState();
    }

    @Override
    public boolean getVuLeftClipState() {
        ITrack selectedTrack = this.getPinnedOrSelectedTrack();
        return selectedTrack != null && selectedTrack.getVuLeftClipState();
    }

    @Override
    public boolean getVuRightClipState() {
        ITrack selectedTrack = this.getPinnedOrSelectedTrack();
        return selectedTrack != null && selectedTrack.getVuRightClipState();
    }

    @Override
    public boolean hasDrumDevice() {
        ITrack selectedTrack = this.getPinnedOrSelectedTrack();
        return selectedTrack != null && selectedTrack.hasDrumDevice();
    }

    @Override
    public void remove() {
        ITrack selectedTrack = this.getPinnedOrSelectedTrack();
        if (selectedTrack != null) {
            selectedTrack.remove();
        }
    }

    @Override
    public void duplicate() {
        ITrack selectedTrack = this.getPinnedOrSelectedTrack();
        if (selectedTrack != null) {
            selectedTrack.duplicate();
        }
    }

    @Override
    public ISendBank getSendBank() {
        ITrack selectedTrack = this.getPinnedOrSelectedTrack();
        return selectedTrack != null ? selectedTrack.getSendBank() : EmptySendBank.getInstance(this.numSends);
    }

    @Override
    public void enter() {
        ITrack selectedTrack = this.getPinnedOrSelectedTrack();
        if (selectedTrack != null) {
            selectedTrack.enter();
        }
    }

    @Override
    public void addColorObserver(IValueObserver<ColorEx> observer) {
        ITrack selectedTrack = this.getPinnedOrSelectedTrack();
        if (selectedTrack != null) {
            selectedTrack.addColorObserver(observer);
        }
    }

    @Override
    public boolean doesExist() {
        ITrack selectedTrack = this.getPinnedOrSelectedTrack();
        return selectedTrack != null && selectedTrack.doesExist();
    }

    @Override
    public int getIndex() {
        ITrack selectedTrack = this.getPinnedOrSelectedTrack();
        return selectedTrack != null ? selectedTrack.getIndex() : -1;
    }

    @Override
    public int getPosition() {
        ITrack selectedTrack = this.getPinnedOrSelectedTrack();
        return selectedTrack != null ? selectedTrack.getPosition() : 0;
    }

    @Override
    public boolean isSelected() {
        if (this.isPinned) {
            return true;
        }
        ITrack selectedTrack = this.getSelectedTrack();
        return selectedTrack != null && selectedTrack.isSelected();
    }

    @Override
    public void setSelected(boolean isSelected) {
        ITrack selectedTrack = this.getPinnedOrSelectedTrack();
        if (selectedTrack != null) {
            selectedTrack.setSelected(isSelected);
        }
    }

    @Override
    public void select() {
        ITrack selectedTrack = this.getPinnedOrSelectedTrack();
        if (selectedTrack != null) {
            selectedTrack.select();
        }
    }

    @Override
    public void toggleMultiSelect() {
        ITrack selectedTrack = this.getPinnedOrSelectedTrack();
        if (selectedTrack != null) {
            selectedTrack.toggleMultiSelect();
        }
    }

    @Override
    public String getName() {
        ITrack selectedTrack = this.getPinnedOrSelectedTrack();
        return selectedTrack != null ? selectedTrack.getName() : "";
    }

    @Override
    public String getName(int limit) {
        ITrack selectedTrack = this.getPinnedOrSelectedTrack();
        return selectedTrack != null ? selectedTrack.getName(limit) : "";
    }

    @Override
    public void addNameObserver(IValueObserver<String> observer) {
        ITrack selectedTrack = this.getPinnedOrSelectedTrack();
        if (selectedTrack != null) {
            selectedTrack.select();
        }
    }

    @Override
    public void setName(String name) {
        ITrack selectedTrack = this.getPinnedOrSelectedTrack();
        if (selectedTrack != null) {
            selectedTrack.setName(name);
        }
    }

    @Override
    public void enableObservers(boolean enable) {
        ITrack selectedTrack = this.getPinnedOrSelectedTrack();
        if (selectedTrack != null) {
            selectedTrack.enableObservers(enable);
        }
    }

    @Override
    public boolean canSelectPrevious() {
        return this.model.getTrackBank().canScrollBackwards();
    }

    @Override
    public boolean canSelectNext() {
        return this.model.getTrackBank().canScrollForwards();
    }

    @Override
    public void selectPrevious() {
        this.model.getTrackBank().selectPreviousItem();
    }

    @Override
    public void selectNext() {
        this.model.getTrackBank().selectNextItem();
    }

    @Override
    public void swapWithPrevious() {
        this.sendPositionedItemOSC("movePrev");
        ((ITrack)this.model.getTrackBank().getItem(Math.max(0, this.getIndex() - 1))).select();
    }

    @Override
    public void swapWithNext() {
        this.sendPositionedItemOSC("moveNext");
        ((ITrack)this.model.getTrackBank().getItem(Math.min(this.model.getTrackBank().getPageSize() - 1, this.getIndex() + 1))).select();
    }

    @Override
    public boolean isPinned() {
        return this.isPinned;
    }

    @Override
    public void togglePinned() {
        this.setPinned(!this.isPinned);
    }

    @Override
    public void setPinned(boolean isPinned) {
        if (isPinned) {
            this.pinnedTrack = this.getSelectedTrack();
            if (this.pinnedTrack == null || !this.pinnedTrack.doesExist()) {
                this.setPinned(false);
                return;
            }
        } else {
            this.pinnedTrack = null;
        }
        this.isPinned = isPinned;
        this.sendPositionedItemOSC("pin", this.pinnedTrack == null ? -1 : this.pinnedTrack.getPosition());
    }

    public ITrack getPinnedTrack() {
        return this.pinnedTrack;
    }

    @Override
    public void addDevice(IDeviceMetadata metadata) {
        ITrack selectedTrack = this.getPinnedOrSelectedTrack();
        if (selectedTrack != null) {
            ((ChannelImpl)((Object)selectedTrack)).addDevice(metadata);
        }
    }

    @Override
    public IParameterBank getParameterBank() {
        return this.parameterBankDelegator;
    }

    public ITrack getPinnedOrSelectedTrack() {
        if (this.isPinned) {
            return this.pinnedTrack;
        }
        return this.getSelectedTrack();
    }

    private ITrack getSelectedTrack() {
        ITrackBank tb = this.model.getTrackBank();
        Optional sel = tb.getSelectedItem();
        if (sel.isPresent()) {
            return (ITrack)sel.get();
        }
        tb = this.model.getEffectTrackBank();
        if (tb != null && (sel = tb.getSelectedItem()).isPresent()) {
            return (ITrack)sel.get();
        }
        IMasterTrack masterTrack = this.model.getMasterTrack();
        return masterTrack.isSelected() ? masterTrack : null;
    }

    public void sendPositionedItemOSC(String command, double value) {
        ITrack selectedTrack = this.getSelectedTrack();
        if (selectedTrack != null) {
            ((ChannelImpl)((Object)selectedTrack)).sendPositionedItemOSC(command, value);
        }
    }

    private void sendPositionedItemOSC(String command, int value) {
        ITrack selectedTrack = this.getSelectedTrack();
        if (selectedTrack != null) {
            ((ChannelImpl)((Object)selectedTrack)).sendPositionedItemOSC(command, value);
        }
    }

    private void sendPositionedItemOSC(String command, boolean value) {
        ITrack selectedTrack = this.getSelectedTrack();
        if (selectedTrack != null) {
            ((ChannelImpl)((Object)selectedTrack)).sendPositionedItemOSC(command, value);
        }
    }

    private void sendPositionedItemOSC(String command) {
        ITrack selectedTrack = this.getSelectedTrack();
        if (selectedTrack != null) {
            ((ChannelImpl)((Object)selectedTrack)).sendPositionedItemOSC(command);
        }
    }
}

