/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.framework.view.sequencer;

import de.mossgrabers.framework.configuration.Configuration;
import de.mossgrabers.framework.controller.IControlSurface;
import de.mossgrabers.framework.controller.grid.IPadGrid;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.clip.INoteClip;
import de.mossgrabers.framework.daw.midi.INoteRepeat;
import de.mossgrabers.framework.view.sequencer.AbstractDrumView;

public abstract class AbstractDrumExView<S extends IControlSurface<C>, C extends Configuration>
extends AbstractDrumView<S, C> {
    public static final String COLOR_EX_SELECT_ON = "COLOR_EX_SELECT_ON";
    public static final String COLOR_EX_SELECT_OFF = "COLOR_EX_SELECT_OFF";
    public static final String COLOR_EX_MUTE_ON = "COLOR_EX_MUTE_ON";
    public static final String COLOR_EX_MUTE_OFF = "COLOR_EX_MUTE_OFF";
    public static final String COLOR_EX_SOLO_ON = "COLOR_EX_SOLO_ON";
    public static final String COLOR_EX_SOLO_OFF = "COLOR_EX_SOLO_OFF";
    public static final String COLOR_EX_BROWSE_ON = "COLOR_EX_BROWSE_ON";
    public static final String COLOR_EX_BROWSE_OFF = "COLOR_EX_BROWSE_OFF";
    public static final String COLOR_EX_NOTE_REPEAT_ON = "COLOR_EX_NOTE_REPEAT_ON";
    public static final String COLOR_EX_NOTE_REPEAT_OFF = "COLOR_EX_NOTE_REPEAT_OFF";
    public static final String COLOR_EX_NOTE_REPEAT_PERIOD_ON = "COLOR_EX_NOTE_REPEAT_PERIOD_ON";
    public static final String COLOR_EX_NOTE_REPEAT_PERIOD_OFF = "COLOR_EX_NOTE_REPEAT_PERIOD_OFF";
    public static final String COLOR_EX_NOTE_REPEAT_LENGTH_ON = "COLOR_EX_NOTE_REPEAT_LENGTH_ON";
    public static final String COLOR_EX_NOTE_REPEAT_LENGTH_OFF = "COLOR_EX_NOTE_REPEAT_LENGTH_OFF";
    public static final String COLOR_EX_TOGGLE_ON = "COLOR_EX_TOGGLE_ON";
    public static final String COLOR_EX_TOGGLE_OFF = "COLOR_EX_TOGGLE_OFF";
    protected boolean extraButtonsOn = false;
    protected boolean noteRepeatPeriodOn = false;
    protected boolean noteRepeatLengthOn = false;
    protected boolean useExtraToggleButton = true;
    protected int firstExtraPad = (this.playRows - 2) * this.playColumns;

    protected AbstractDrumExView(String name, S surface, IModel model, int numSequencerLines, int numPlayLines, boolean useDawColors) {
        super(name, surface, model, numSequencerLines, numPlayLines, useDawColors);
    }

    @Override
    protected void handleLoopArea(int pad, int velocity) {
        if (!this.extraButtonsOn || pad < this.firstExtraPad) {
            super.handleLoopArea(pad, velocity);
            return;
        }
        if (velocity == 0) {
            return;
        }
        if (pad == this.firstExtraPad + 4) {
            this.surface.getConfiguration().toggleNoteRepeatActive();
            return;
        }
        if (pad == this.firstExtraPad + 5) {
            boolean bl = this.noteRepeatPeriodOn = !this.noteRepeatPeriodOn;
            if (this.noteRepeatPeriodOn) {
                this.noteRepeatLengthOn = false;
            }
            return;
        }
        if (pad == this.firstExtraPad + 6) {
            boolean bl = this.noteRepeatLengthOn = !this.noteRepeatLengthOn;
            if (this.noteRepeatLengthOn) {
                this.noteRepeatPeriodOn = false;
            }
        }
    }

    protected void toggleExtraButtons() {
        this.extraButtonsOn = !this.extraButtonsOn;
    }

    @Override
    protected int getNumberOfAvailablePages() {
        return super.getNumberOfAvailablePages() - (this.extraButtonsOn ? 8 : 0);
    }

    @Override
    protected void drawPages(INoteClip clip, boolean isActive) {
        super.drawPages(clip, isActive);
        IPadGrid padGrid = this.surface.getPadGrid();
        if (this.extraButtonsOn) {
            int row = this.allRows - 2;
            padGrid.lightEx(4, row, this.colorManager.getColorIndex(this.isSelectTrigger() ? COLOR_EX_SELECT_ON : COLOR_EX_SELECT_OFF));
            padGrid.lightEx(5, row, this.colorManager.getColorIndex(this.isMuteTrigger() ? COLOR_EX_MUTE_ON : COLOR_EX_MUTE_OFF));
            padGrid.lightEx(6, row, this.colorManager.getColorIndex(this.isSoloTrigger() ? COLOR_EX_SOLO_ON : COLOR_EX_SOLO_OFF));
            padGrid.lightEx(7, row, this.colorManager.getColorIndex(this.isBrowseTrigger() ? COLOR_EX_BROWSE_ON : COLOR_EX_BROWSE_OFF));
            INoteRepeat noteRepeat = this.surface.getMidiInput().getDefaultNoteInput().getNoteRepeat();
            padGrid.lightEx(4, ++row, this.colorManager.getColorIndex(noteRepeat.isActive() ? COLOR_EX_NOTE_REPEAT_ON : COLOR_EX_NOTE_REPEAT_OFF));
            padGrid.lightEx(5, row, this.colorManager.getColorIndex(this.noteRepeatPeriodOn ? COLOR_EX_NOTE_REPEAT_PERIOD_ON : COLOR_EX_NOTE_REPEAT_PERIOD_OFF));
            padGrid.lightEx(6, row, this.colorManager.getColorIndex(this.noteRepeatLengthOn ? COLOR_EX_NOTE_REPEAT_LENGTH_ON : COLOR_EX_NOTE_REPEAT_LENGTH_OFF));
        }
        if (this.useExtraToggleButton || this.extraButtonsOn) {
            padGrid.lightEx(7, this.allRows - 1, this.colorManager.getColorIndex(this.extraButtonsOn ? COLOR_EX_TOGGLE_ON : COLOR_EX_TOGGLE_OFF));
        }
    }
}

