/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.framework.mode.track;

import de.mossgrabers.framework.configuration.Configuration;
import de.mossgrabers.framework.controller.ButtonID;
import de.mossgrabers.framework.controller.ContinuousID;
import de.mossgrabers.framework.controller.IControlSurface;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.data.ITrack;
import de.mossgrabers.framework.mode.track.DefaultTrackMode;
import de.mossgrabers.framework.parameterprovider.track.PanParameterProvider;
import java.util.List;
import java.util.Optional;
import java.util.function.BooleanSupplier;

public class TrackPanMode<S extends IControlSurface<C>, C extends Configuration>
extends DefaultTrackMode<S, C> {
    public TrackPanMode(S surface, IModel model, boolean isAbsolute) {
        this(surface, model, isAbsolute, null);
    }

    public TrackPanMode(S surface, IModel model, boolean isAbsolute, List<ContinuousID> controls) {
        this(surface, model, isAbsolute, controls, () -> surface.isShiftPressed());
    }

    public TrackPanMode(S surface, IModel model, boolean isAbsolute, List<ContinuousID> controls, BooleanSupplier isAlternativeFunction) {
        super("Panning", surface, model, isAbsolute, controls, isAlternativeFunction);
        if (controls != null) {
            this.setParameterProvider(new PanParameterProvider(model));
        }
    }

    @Override
    public void onKnobValue(int index, int value) {
        Optional<ITrack> track = this.getTrack(index);
        if (track.isEmpty()) {
            return;
        }
        ITrack t = track.get();
        if (this.isAbsolute) {
            t.setPan(value);
        } else {
            t.changePan(value);
        }
    }

    @Override
    public void onKnobTouch(int index, boolean isTouched) {
        Optional<ITrack> track = this.getTrack(index);
        if (track.isEmpty()) {
            return;
        }
        ITrack t = track.get();
        if (!t.doesExist()) {
            return;
        }
        if (isTouched && this.surface.isDeletePressed()) {
            this.surface.setTriggerConsumed(ButtonID.DELETE);
            t.resetPan();
        }
        t.touchPan(isTouched);
    }

    @Override
    public int getKnobValue(int index) {
        Optional<ITrack> track = this.getTrack(index);
        return track.isEmpty() ? -1 : track.get().getPan();
    }
}

