/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.framework.command.trigger.clip;

import de.mossgrabers.framework.command.core.AbstractTriggerCommand;
import de.mossgrabers.framework.configuration.Configuration;
import de.mossgrabers.framework.controller.ButtonID;
import de.mossgrabers.framework.controller.IControlSurface;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.featuregroup.ModeManager;
import de.mossgrabers.framework.featuregroup.ViewManager;
import de.mossgrabers.framework.mode.Modes;
import de.mossgrabers.framework.utils.ButtonEvent;
import de.mossgrabers.framework.view.Views;

public class NoteRepeatCommand<S extends IControlSurface<C>, C extends Configuration>
extends AbstractTriggerCommand<S, C> {
    private final EditMode editMode;

    public NoteRepeatCommand(IModel model, S surface) {
        super(model, surface);
        this.editMode = EditMode.NONE;
    }

    public NoteRepeatCommand(IModel model, S surface, boolean isMode) {
        super(model, surface);
        this.editMode = isMode ? EditMode.MODE : EditMode.VIEW;
    }

    @Override
    public void execute(ButtonEvent event, int velocity) {
        if (this.editMode == EditMode.NONE) {
            if (event == ButtonEvent.UP) {
                this.surface.getConfiguration().toggleNoteRepeatActive();
            }
            return;
        }
        if (!this.handleEditModeActivation(event)) {
            this.surface.getConfiguration().toggleNoteRepeatActive();
        }
    }

    protected boolean handleEditModeActivation(ButtonEvent event) {
        boolean isMode;
        boolean bl = isMode = this.editMode == EditMode.MODE;
        if (event == ButtonEvent.LONG || event == ButtonEvent.DOWN && this.surface.isShiftPressed()) {
            if (isMode) {
                this.surface.getModeManager().setTemporary(Modes.REPEAT_NOTE);
            } else {
                this.surface.getViewManager().setActive(Views.REPEAT_NOTE);
            }
            this.surface.setTriggerConsumed(ButtonID.REPEAT);
            return true;
        }
        if (event != ButtonEvent.UP) {
            return true;
        }
        if (isMode) {
            ModeManager modeManager = this.surface.getModeManager();
            if (modeManager.isActive(new Modes[]{Modes.REPEAT_NOTE})) {
                modeManager.restore();
                return true;
            }
        } else {
            ViewManager viewManager = this.surface.getViewManager();
            if (viewManager.isActive(new Views[]{Views.REPEAT_NOTE})) {
                viewManager.restore();
                return true;
            }
        }
        return false;
    }

    private static enum EditMode {
        NONE,
        MODE,
        VIEW;

    }
}

