/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.osc.module;

import de.mossgrabers.controller.osc.exception.IllegalParameterException;
import de.mossgrabers.controller.osc.exception.MissingCommandException;
import de.mossgrabers.controller.osc.module.IModule;
import de.mossgrabers.framework.controller.color.ColorEx;
import de.mossgrabers.framework.daw.IHost;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.clip.IClip;
import de.mossgrabers.framework.daw.data.ISend;
import de.mossgrabers.framework.osc.IOpenSoundControlWriter;
import de.mossgrabers.framework.parameter.IParameter;
import java.util.LinkedList;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class AbstractModule
implements IModule {
    private static final Pattern RGB_COLOR_PATTERN = Pattern.compile("(rgb|RGB)\\((\\d+(\\.\\d+)?),(\\d+(\\.\\d+)?),(\\d+(\\.\\d+)?)\\)");
    protected static final String TAG_EXISTS = "exists";
    protected static final String TAG_ACTIVATED = "activated";
    protected static final String TAG_NAME = "name";
    protected static final String TAG_SELECTED = "selected";
    protected static final String TAG_SELECT = "select";
    protected static final String TAG_DUPLICATE = "duplicate";
    protected static final String TAG_INSERT_FILE = "insertFile";
    protected static final String TAG_REMOVE = "remove";
    protected static final String TAG_VOLUME = "volume";
    protected static final String TAG_PAGE = "page";
    protected static final String TAG_INDICATE = "indicate";
    protected static final String TAG_TOUCHED = "touched";
    protected static final String TAG_COLOR = "color";
    protected static final String TAG_BYPASS = "bypass";
    protected static final String TAG_PARAM = "param";
    protected static final String TAG_MIXER = "mixer";
    protected static final String TAG_PREROLL = "preroll";
    protected static final String TAG_RESET = "reset";
    protected final IHost host;
    protected final IModel model;
    protected IOpenSoundControlWriter writer;

    protected AbstractModule(IHost host, IModel model, IOpenSoundControlWriter writer) {
        this.host = host;
        this.model = model;
        this.writer = writer;
    }

    @Override
    public void flush(boolean dump) {
    }

    protected IClip getClip() {
        return this.model.getNoteClip(8, 128);
    }

    protected static boolean isTrigger(Object value) {
        Number number;
        return value == null || value instanceof Number && (number = (Number)value).doubleValue() > 0.0;
    }

    protected static int toInteger(Object value) throws IllegalParameterException {
        return (int)AbstractModule.toNumber(value);
    }

    protected static double toNumber(Object value, double defaultValue) throws IllegalParameterException {
        if (value == null) {
            return defaultValue;
        }
        if (value instanceof Number) {
            Number number = (Number)value;
            return number.doubleValue();
        }
        throw new IllegalParameterException("Parameter is not a Number");
    }

    protected static double toNumber(Object value) throws IllegalParameterException {
        if (value == null) {
            throw new IllegalParameterException("Number parameter missing");
        }
        if (value instanceof Number) {
            Number number = (Number)value;
            return number.doubleValue();
        }
        throw new IllegalParameterException("Parameter is not a Number");
    }

    protected static String toString(Object value) throws IllegalParameterException {
        if (value == null) {
            throw new IllegalParameterException("String parameter missing");
        }
        return value.toString();
    }

    protected static String getSubCommand(LinkedList<String> path) throws MissingCommandException {
        if (path.isEmpty()) {
            throw new MissingCommandException();
        }
        return path.removeFirst();
    }

    protected void flushParameterData(IOpenSoundControlWriter writer, String fxAddress, IParameter fxParam, boolean dump) {
        boolean isSend = fxParam instanceof ISend;
        if (isSend) {
            writer.sendOSC(fxAddress + TAG_ACTIVATED, ((ISend)fxParam).isEnabled(), dump);
        }
        writer.sendOSC(fxAddress + TAG_EXISTS, fxParam.doesExist(), dump);
        writer.sendOSC(fxAddress + TAG_NAME, fxParam.getName(), dump);
        writer.sendOSC(fxAddress + (isSend ? "volumeStr" : "valueStr"), fxParam.getDisplayedValue(), dump);
        writer.sendOSC(fxAddress + (isSend ? TAG_VOLUME : "value"), fxParam.getValue(), dump);
        writer.sendOSC(fxAddress + "modulatedValue", fxParam.getModulatedValue(), dump);
    }

    protected static Optional<ColorEx> matchColor(String value) {
        Matcher matcher = RGB_COLOR_PATTERN.matcher(value);
        if (!matcher.matches()) {
            return Optional.empty();
        }
        int count = matcher.groupCount();
        if (count == 7) {
            return Optional.of(new ColorEx(Double.parseDouble(matcher.group(2)) / 255.0, Double.parseDouble(matcher.group(4)) / 255.0, Double.parseDouble(matcher.group(6)) / 255.0));
        }
        return Optional.empty();
    }
}

