/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.novation.sl.mode.device;

import de.mossgrabers.controller.novation.sl.SLConfiguration;
import de.mossgrabers.controller.novation.sl.controller.SLControlSurface;
import de.mossgrabers.framework.controller.ContinuousID;
import de.mossgrabers.framework.controller.display.ITextDisplay;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.data.ICursorDevice;
import de.mossgrabers.framework.daw.data.bank.IParameterBank;
import de.mossgrabers.framework.mode.device.ParameterMode;
import de.mossgrabers.framework.parameter.IParameter;
import de.mossgrabers.framework.utils.StringUtils;

public class SLParameterMode
extends ParameterMode<SLControlSurface, SLConfiguration> {
    public SLParameterMode(SLControlSurface surface, IModel model) {
        super(surface, model, false, ContinuousID.createSequentialList(ContinuousID.DEVICE_KNOB1, 8));
    }

    @Override
    public void updateDisplay() {
        ITextDisplay d = ((SLControlSurface)this.surface).getTextDisplay().clearRow(0).clearRow(1);
        ICursorDevice cd = this.model.getCursorDevice();
        if (!cd.doesExist()) {
            d.setRow(0, "                       Please select a device...                       ");
            d.done(0).done(1);
            return;
        }
        IParameterBank parameterBank = cd.getParameterBank();
        for (int i = 0; i < 8; ++i) {
            IParameter param = (IParameter)parameterBank.getItem(i);
            d.setCell(0, i, param.doesExist() ? StringUtils.shortenAndFixASCII(param.getName(), 8) : "");
            d.setCell(1, i, StringUtils.shortenAndFixASCII(param.getDisplayedValue(8), 8));
        }
        d.done(0).done(1);
    }

    @Override
    public void onActivate() {
        if (!this.isActive) {
            super.onActivate();
        }
    }

    @Override
    public void onDeactivate() {
    }
}

