/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.novation.launchpad.view;

import de.mossgrabers.controller.novation.launchpad.LaunchpadConfiguration;
import de.mossgrabers.controller.novation.launchpad.controller.LaunchpadControlSurface;
import de.mossgrabers.framework.daw.GrooveParameterID;
import de.mossgrabers.framework.daw.IGroove;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.featuregroup.IScrollableView;
import de.mossgrabers.framework.parameter.IParameter;
import de.mossgrabers.framework.utils.ScrollStates;
import de.mossgrabers.framework.view.ShuffleView;

public class LaunchpadShuffleView
extends ShuffleView<LaunchpadControlSurface, LaunchpadConfiguration>
implements IScrollableView {
    public LaunchpadShuffleView(LaunchpadControlSurface surface, IModel model, int textColor1, int textColor2, int backgroundColor) {
        super(surface, model, textColor1, textColor2, backgroundColor);
    }

    @Override
    public void onGridNote(int note, int velocity) {
        IParameter rateParameter;
        IGroove groove;
        IParameter enabledParameter;
        if (velocity != 0) {
            return;
        }
        if (note == 36 && (enabledParameter = (groove = this.model.getGroove()).getParameter(GrooveParameterID.ENABLED)) != null) {
            enabledParameter.setNormalizedValue(enabledParameter.getValue() == 0 ? 1.0 : 0.0);
            return;
        }
        if ((note == 38 || note == 39) && (rateParameter = (groove = this.model.getGroove()).getParameter(GrooveParameterID.SHUFFLE_RATE)) != null) {
            rateParameter.setNormalizedValue(rateParameter.getValue() == 0 ? 1.0 : 0.0);
            return;
        }
        ((LaunchpadControlSurface)this.surface).getViewManager().restore();
    }

    @Override
    protected void fillBottom() {
        super.fillBottom();
        IGroove groove = this.model.getGroove();
        IParameter enabledParameter = groove.getParameter(GrooveParameterID.ENABLED);
        if (enabledParameter == null || !enabledParameter.doesExist()) {
            return;
        }
        this.padGrid.lightEx(0, 7, enabledParameter.getValue() == 0 ? 2 : 21);
        IParameter rateParameter = groove.getParameter(GrooveParameterID.SHUFFLE_RATE);
        if (rateParameter == null || !rateParameter.doesExist()) {
            return;
        }
        boolean isEight = rateParameter.getValue() == 0;
        this.padGrid.lightEx(2, 7, isEight ? 45 : 2);
        this.padGrid.lightEx(3, 7, !isEight ? 45 : 2);
    }

    @Override
    public void updateScrollStates(ScrollStates scrollStates) {
        scrollStates.setAll(true);
    }
}

