/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.novation.launchkey.maxi.mode;

import de.mossgrabers.controller.novation.launchkey.maxi.LaunchkeyMk3Configuration;
import de.mossgrabers.controller.novation.launchkey.maxi.controller.LaunchkeyMk3ControlSurface;
import de.mossgrabers.framework.controller.ContinuousID;
import de.mossgrabers.framework.controller.display.ITextDisplay;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.data.ICursorTrack;
import de.mossgrabers.framework.daw.data.IMasterTrack;
import de.mossgrabers.framework.daw.data.bank.IParameterBank;
import de.mossgrabers.framework.mode.device.ParameterMode;
import de.mossgrabers.framework.parameter.IParameter;
import java.util.List;

public class LaunchkeyMk3ParameterMode
extends ParameterMode<LaunchkeyMk3ControlSurface, LaunchkeyMk3Configuration> {
    private final boolean areKnobs;

    public LaunchkeyMk3ParameterMode(LaunchkeyMk3ControlSurface surface, IModel model, List<ContinuousID> controls) {
        super(surface, model, true, controls);
        this.areKnobs = controls.get(0) == ContinuousID.KNOB1;
    }

    @Override
    public void updateDisplay() {
        ITextDisplay d = ((LaunchkeyMk3ControlSurface)this.surface).getTextDisplay();
        if (this.areKnobs) {
            StringBuilder sb = new StringBuilder();
            if (this.cursorDevice.doesExist()) {
                sb.append(this.cursorDevice.getName(8)).append(' ').append(this.cursorDevice.getParameterBank().getPageBank().getSelectedItem());
            } else {
                sb.append("No device");
            }
            d.setCell(0, 0, sb.toString());
            ICursorTrack cursorTrack = this.model.getCursorTrack();
            String trackText = cursorTrack.doesExist() ? String.format("%d: %s", cursorTrack.getPosition() + 1, cursorTrack.getName()) : "No sel. track";
            d.setCell(1, 0, trackText);
        }
        int row = this.areKnobs ? 2 : 18;
        IParameterBank parameterBank = this.cursorDevice.getParameterBank();
        for (int i = 0; i < 8; ++i) {
            IParameter item = (IParameter)parameterBank.getItem(i);
            boolean exists = item.doesExist();
            int offset = i * 2;
            d.setCell(row + offset, 0, exists ? item.getName() : "No parameter");
            d.setCell(row + offset + 1, 0, exists ? item.getDisplayedValue() : "");
        }
        if (!this.areKnobs) {
            IMasterTrack masterTrack = this.model.getMasterTrack();
            d.setCell(row + 16, 0, "Master");
            d.setCell(row + 16 + 1, 0, "Vol: " + masterTrack.getVolumeStr());
        }
        d.allDone();
    }

    @Override
    public void selectPreviousItem() {
        super.selectPreviousItemPage();
    }

    @Override
    public void selectNextItem() {
        super.selectNextItemPage();
    }
}

