/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.arturia.beatstep.view;

import de.mossgrabers.controller.arturia.beatstep.BeatstepConfiguration;
import de.mossgrabers.controller.arturia.beatstep.controller.BeatstepControlSurface;
import de.mossgrabers.controller.arturia.beatstep.view.BeatstepView;
import de.mossgrabers.controller.arturia.beatstep.view.TrackEditing;
import de.mossgrabers.framework.controller.color.ColorManager;
import de.mossgrabers.framework.controller.grid.IPadGrid;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.scale.Scales;
import de.mossgrabers.framework.view.AbstractPlayView;

public class PlayView
extends AbstractPlayView<BeatstepControlSurface, BeatstepConfiguration>
implements BeatstepView {
    private final TrackEditing extensions;

    public PlayView(BeatstepControlSurface surface, IModel model) {
        super("Play", surface, model, false);
        this.extensions = new TrackEditing(surface, model);
    }

    @Override
    public void onKnob(int index, int value) {
        boolean isIncrease = this.model.getValueChanger().isIncrease(value);
        switch (index) {
            case 12: {
                this.scales.setChromatic(!isIncrease);
                ((BeatstepConfiguration)((BeatstepControlSurface)this.surface).getConfiguration()).setScaleInKey(isIncrease);
                ((BeatstepControlSurface)this.surface).getDisplay().notify(isIncrease ? "In Key" : "Chromatic");
                break;
            }
            case 13: {
                if (isIncrease) {
                    this.scales.nextScaleOffset();
                } else {
                    this.scales.prevScaleOffset();
                }
                String scaleBase = Scales.BASES.get(this.scales.getScaleOffsetIndex());
                ((BeatstepControlSurface)this.surface).getDisplay().notify(scaleBase);
                ((BeatstepConfiguration)((BeatstepControlSurface)this.surface).getConfiguration()).setScaleBase(scaleBase);
                break;
            }
            case 14: {
                if (isIncrease) {
                    this.scales.nextScale();
                } else {
                    this.scales.prevScale();
                }
                String scale = this.scales.getScale().getName();
                ((BeatstepConfiguration)((BeatstepControlSurface)this.surface).getConfiguration()).setScale(scale);
                ((BeatstepControlSurface)this.surface).getDisplay().notify(scale);
                break;
            }
            case 15: {
                this.keyManager.clearPressedKeys();
                if (isIncrease) {
                    this.scales.incOctave();
                } else {
                    this.scales.decOctave();
                }
                ((BeatstepControlSurface)this.surface).getDisplay().notify("Octave " + (this.scales.getOctave() > 0 ? "+" : "") + this.scales.getOctave() + " (" + this.scales.getRangeText() + ")");
                break;
            }
            default: {
                this.extensions.onTrackKnob(index, value);
            }
        }
        this.updateNoteMapping();
    }

    @Override
    public void drawGrid() {
        boolean isKeyboardEnabled = this.model.canSelectedTrackHoldNotes();
        IPadGrid padGrid = ((BeatstepControlSurface)this.surface).getPadGrid();
        for (int i = 36; i < 52; ++i) {
            padGrid.light(i, this.getPadColor(isKeyboardEnabled, i));
        }
    }

    protected int getPadColor(boolean isKeyboardEnabled, int pad) {
        if (!isKeyboardEnabled) {
            return 0;
        }
        if (this.keyManager.isKeyPressed(pad)) {
            return 17;
        }
        ColorManager colorManager = this.model.getColorManager();
        return colorManager.getColorIndex(this.keyManager.getColor(pad));
    }
}

