/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.akai.apc.view;

import de.mossgrabers.controller.akai.apc.APCConfiguration;
import de.mossgrabers.controller.akai.apc.controller.APCControlSurface;
import de.mossgrabers.framework.controller.ButtonID;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.utils.ButtonEvent;
import de.mossgrabers.framework.view.sequencer.AbstractRaindropsView;

public class RaindropsView
extends AbstractRaindropsView<APCControlSurface, APCConfiguration> {
    public RaindropsView(APCControlSurface surface, IModel model) {
        super("Raindrops", surface, model, surface.isMkII());
        this.numDisplayRows = 5;
    }

    @Override
    public void onButton(ButtonID buttonID, ButtonEvent event, int velocity) {
        if (!ButtonID.isSceneButton(buttonID) || event != ButtonEvent.DOWN || !this.isActive()) {
            return;
        }
        this.ongoingResolutionChange = true;
        switch (buttonID) {
            case SCENE1: {
                this.scales.nextScale();
                this.notifyScale();
                break;
            }
            case SCENE2: {
                this.scales.prevScale();
                this.notifyScale();
                break;
            }
            case SCENE3: {
                this.scales.toggleChromatic();
                boolean isChromatic = this.scales.isChromatic();
                ((APCConfiguration)((APCControlSurface)this.surface).getConfiguration()).setScaleInKey(!isChromatic);
                ((APCControlSurface)this.surface).getDisplay().notify(isChromatic ? "Chromatic" : "In Key");
                break;
            }
            case SCENE4: {
                this.onOctaveUp(event);
                break;
            }
            case SCENE5: {
                this.onOctaveDown(event);
                break;
            }
        }
        this.updateNoteMapping();
        this.ongoingResolutionChange = false;
    }

    @Override
    public String getButtonColorID(ButtonID buttonID) {
        if (buttonID == ButtonID.SCENE3) {
            return "BUTTON_STATE_OFF";
        }
        return this.isActive() ? "BUTTON_STATE_ON" : "BUTTON_STATE_OFF";
    }

    private void notifyScale() {
        String name = this.scales.getScale().getName();
        ((APCConfiguration)((APCControlSurface)this.surface).getConfiguration()).setScale(name);
        ((APCControlSurface)this.surface).getDisplay().notify(name);
    }
}

