/*
 * Decompiled with CFR 0.152.
 */
package com.illposed.osc;

import com.illposed.osc.OSCMessage;
import com.illposed.osc.OSCMessageEvent;
import com.illposed.osc.OSCMessageListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EchoOSCMessageListener
implements OSCMessageListener {
    private final Logger log;

    public EchoOSCMessageListener(Logger log) {
        this.log = log;
    }

    public EchoOSCMessageListener() {
        this(LoggerFactory.getLogger(EchoOSCMessageListener.class));
    }

    @Override
    public void acceptMessage(OSCMessageEvent event) {
        OSCMessage message = event.getMessage();
        this.log.info(message.getAddress());
        this.log.info("  {}", (Object)message.getInfo().getArgumentTypeTags());
        for (Object arg : message.getArguments()) {
            this.log.info("    {}", arg);
        }
        this.log.info("");
    }
}

