/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.reaper.framework.configuration;

import de.mossgrabers.framework.configuration.IColorSetting;
import de.mossgrabers.framework.controller.color.ColorEx;
import de.mossgrabers.reaper.framework.configuration.BaseValueSetting;
import de.mossgrabers.reaper.ui.utils.LogModel;
import de.mossgrabers.reaper.ui.utils.PropertiesEx;
import de.mossgrabers.reaper.ui.utils.SafeRunLater;
import de.mossgrabers.reaper.ui.widget.ColoredButton;
import java.awt.Color;
import javax.swing.JColorChooser;

public class ColorSettingImpl
extends BaseValueSetting<ColoredButton, ColorEx>
implements IColorSetting {
    private final ColorEx initialValue;
    private ColorEx value;

    public ColorSettingImpl(LogModel logModel, PropertiesEx properties, String label, String category, ColorEx initialValue) {
        super(logModel, label, category, new ColoredButton());
        this.initialValue = initialValue;
        this.load(properties);
        ((ColoredButton)this.field).setBackground(new Color((float)this.value.getRed(), (float)this.value.getGreen(), (float)this.value.getBlue()));
        ((ColoredButton)this.field).addActionListener(event -> {
            Color c = JColorChooser.showDialog(this.field, "Pick color", ((ColoredButton)this.field).getBackground());
            if (c != null) {
                this.set((double)c.getRed() / 255.0, (double)c.getGreen() / 255.0, (double)c.getBlue() / 255.0);
            }
        });
    }

    @Override
    public void set(double[] value) {
        this.set(value[0], value[1], value[2]);
    }

    @Override
    public void set(double red, double green, double blue) {
        this.set(new ColorEx(red, green, blue));
    }

    @Override
    public void set(ColorEx value) {
        this.value = value;
        this.setDirty();
        this.flush();
        SafeRunLater.execute(this.logModel, () -> ((ColoredButton)this.field).setBackground(new Color((float)this.value.getRed(), (float)this.value.getGreen(), (float)this.value.getBlue())));
    }

    @Override
    public ColorEx get() {
        return this.value;
    }

    @Override
    public void flush() {
        this.notifyObservers(this.value);
    }

    @Override
    public void store(PropertiesEx properties) {
        properties.put(this.getID(), this.value.getRed() + "," + this.value.getGreen() + "," + this.value.getBlue());
    }

    @Override
    public void load(PropertiesEx properties) {
        this.value = this.initialValue;
        String color = properties.getString(this.getID());
        if (color == null) {
            return;
        }
        String[] parts = color.split(",");
        if (parts.length == 3) {
            this.set(new ColorEx(Double.parseDouble(parts[0]), Double.parseDouble(parts[1]), Double.parseDouble(parts[2])));
        }
    }

    @Override
    public void reset() {
        this.set(this.initialValue);
    }
}

