/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.novation.launchpad.view;

import de.mossgrabers.controller.novation.launchpad.view.AbstractFaderView;
import de.mossgrabers.framework.controller.grid.IVirtualFaderCallback;
import de.mossgrabers.framework.featuregroup.IView;
import de.mossgrabers.framework.featuregroup.ViewManager;

public class VirtualFaderViewCallback
implements IVirtualFaderCallback {
    private final int index;
    private final ViewManager viewManager;

    public VirtualFaderViewCallback(int index, ViewManager viewManager) {
        this.index = index;
        this.viewManager = viewManager;
    }

    @Override
    public int getValue() {
        IView activeView = (IView)this.viewManager.getActive();
        if (activeView instanceof AbstractFaderView) {
            AbstractFaderView faderView = (AbstractFaderView)activeView;
            return faderView.getFaderValue(this.index);
        }
        return 0;
    }

    @Override
    public void setValue(int value) {
        IView activeView = (IView)this.viewManager.getActive();
        if (activeView instanceof AbstractFaderView) {
            AbstractFaderView faderView = (AbstractFaderView)activeView;
            faderView.onValueKnob(this.index, value);
        }
    }
}

