/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.novation.launchpad.view;

import de.mossgrabers.controller.novation.launchpad.LaunchpadConfiguration;
import de.mossgrabers.controller.novation.launchpad.controller.LaunchpadControlSurface;
import de.mossgrabers.framework.command.trigger.transport.ConfiguredRecordCommand;
import de.mossgrabers.framework.configuration.AbstractConfiguration;
import de.mossgrabers.framework.controller.ButtonID;
import de.mossgrabers.framework.controller.grid.IPadGrid;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.ITransport;
import de.mossgrabers.framework.daw.constants.Resolution;
import de.mossgrabers.framework.daw.midi.INoteRepeat;
import de.mossgrabers.framework.daw.resource.ChannelType;
import de.mossgrabers.framework.featuregroup.IScrollableView;
import de.mossgrabers.framework.utils.ButtonEvent;
import de.mossgrabers.framework.utils.ScrollStates;
import de.mossgrabers.framework.view.AbstractShiftView;
import java.util.EnumMap;
import java.util.Map;

public class ShiftView
extends AbstractShiftView<LaunchpadControlSurface, LaunchpadConfiguration>
implements IScrollableView {
    private static final String TAG_ACTIVE = "Active";
    private static final Map<ButtonID, ButtonID> CONTROL_MODES = new EnumMap<ButtonID, ButtonID>(ButtonID.class);
    private static final Map<ButtonID, Integer> MODE_COLORS = new EnumMap<ButtonID, Integer>(ButtonID.class);
    private final LaunchpadConfiguration configuration;
    private final ConfiguredRecordCommand<LaunchpadControlSurface, LaunchpadConfiguration> configuredRecordCommand;
    private final ConfiguredRecordCommand<LaunchpadControlSurface, LaunchpadConfiguration> configuredShiftedRecordCommand;

    public ShiftView(LaunchpadControlSurface surface, IModel model) {
        super("Shift", surface, model);
        this.configuration = (LaunchpadConfiguration)((LaunchpadControlSurface)this.surface).getConfiguration();
        this.configuredRecordCommand = new ConfiguredRecordCommand(false, this.model, surface);
        this.configuredShiftedRecordCommand = new ConfiguredRecordCommand(true, this.model, surface);
    }

    @Override
    public void drawGrid() {
        int i;
        IPadGrid padGrid = ((LaunchpadControlSurface)this.surface).getPadGrid();
        ITransport transport = this.model.getTransport();
        padGrid.light(97, 22);
        padGrid.light(98, 24);
        padGrid.light(99, 32);
        padGrid.light(91, this.configuration.isAccentActive() ? 13 : 15);
        int clipLengthIndex = this.configuration.getNewClipLength();
        for (int i2 = 0; i2 < 8; ++i2) {
            padGrid.light(36 + i2, i2 == clipLengthIndex ? 3 : 1);
        }
        INoteRepeat noteRepeat = ((LaunchpadControlSurface)this.surface).getMidiInput().getDefaultNoteInput().getNoteRepeat();
        padGrid.light(87, noteRepeat.isActive() ? 49 : 51);
        int periodIndex = Resolution.getMatch(noteRepeat.getPeriod());
        padGrid.light(79, periodIndex == 0 ? 37 : 39);
        padGrid.light(71, periodIndex == 2 ? 37 : 39);
        padGrid.light(63, periodIndex == 4 ? 37 : 39);
        padGrid.light(55, periodIndex == 6 ? 37 : 39);
        padGrid.light(80, periodIndex == 1 ? 57 : 59);
        padGrid.light(72, periodIndex == 3 ? 57 : 59);
        padGrid.light(64, periodIndex == 5 ? 57 : 59);
        padGrid.light(56, periodIndex == 7 ? 57 : 59);
        int lengthIndex = Resolution.getMatch(noteRepeat.getNoteLength());
        padGrid.light(81, lengthIndex == 0 ? 37 : 39);
        padGrid.light(73, lengthIndex == 2 ? 37 : 39);
        padGrid.light(65, lengthIndex == 4 ? 37 : 39);
        padGrid.light(57, lengthIndex == 6 ? 37 : 39);
        padGrid.light(82, lengthIndex == 1 ? 57 : 59);
        padGrid.light(74, lengthIndex == 3 ? 57 : 59);
        padGrid.light(66, lengthIndex == 5 ? 57 : 59);
        padGrid.light(58, lengthIndex == 7 ? 57 : 59);
        padGrid.light(50, 8);
        padGrid.light(51, 6);
        padGrid.light(88, 6);
        padGrid.light(89, 6);
        for (i = 90; i < 91; ++i) {
            padGrid.light(i, 0);
        }
        if (((LaunchpadControlSurface)this.surface).isPro()) {
            for (i = 44; i < 50; ++i) {
                padGrid.light(i, 0);
            }
            for (i = 52; i < 55; ++i) {
                padGrid.light(i, 0);
            }
            for (i = 59; i < 63; ++i) {
                padGrid.light(i, 0);
            }
            for (i = 67; i < 71; ++i) {
                padGrid.light(i, 0);
            }
            for (i = 75; i < 79; ++i) {
                padGrid.light(i, 0);
            }
            for (i = 83; i < 87; ++i) {
                padGrid.light(i, 0);
            }
            for (i = 92; i < 97; ++i) {
                padGrid.light(i, 0);
            }
            return;
        }
        padGrid.light(44, this.configuredRecordCommand.isLit() ? 5 : 7);
        padGrid.light(45, this.configuredShiftedRecordCommand.isLit() ? 4 : 3);
        for (i = 46; i < 50; ++i) {
            padGrid.light(i, 0);
        }
        padGrid.light(52, transport.isPlaying() ? 21 : 23);
        padGrid.light(53, 24);
        padGrid.light(54, 0);
        padGrid.light(59, 0);
        if (this.configuration.isDuplicateModeActive()) {
            padGrid.light(60, 46, 44, true);
        } else {
            padGrid.light(60, 46);
        }
        padGrid.light(61, 48);
        padGrid.light(62, 0);
        padGrid.light(67, 0);
        padGrid.light(68, 22);
        padGrid.light(69, 24);
        padGrid.light(70, 0);
        padGrid.light(75, 0);
        if (this.configuration.isDeleteModeActive()) {
            padGrid.light(76, 54, 56, true);
        } else {
            padGrid.light(76, 54);
        }
        padGrid.light(77, transport.isLoop() ? 45 : 47);
        padGrid.light(78, 0);
        padGrid.light(83, 0);
        padGrid.light(84, 10);
        padGrid.light(85, 12);
        padGrid.light(86, 0);
        padGrid.light(92, transport.isMetronomeOn() ? 21 : 23);
        padGrid.light(93, 24);
        for (i = 94; i < 97; ++i) {
            padGrid.light(i, 0);
        }
    }

    @Override
    public void onGridNote(int note, int velocity) {
        if (velocity == 0) {
            return;
        }
        this.setWasUsed();
        switch (note) {
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: {
                int newClipLength = note - 36;
                this.configuration.setNewClipLength(newClipLength);
                ((LaunchpadControlSurface)this.surface).getDisplay().notify("New clip length: " + AbstractConfiguration.getNewClipLengthValue(newClipLength));
                break;
            }
            case 50: 
            case 51: {
                this.model.getCurrentTrackBank().stop(note == 50);
                ((LaunchpadControlSurface)this.surface).getDisplay().notify(note == 50 ? "Stop All Clips (Alt)" : "Stop All Clips");
                break;
            }
            case 87: {
                this.configuration.toggleNoteRepeatActive();
                this.mvHelper.delayDisplay(() -> "Note Repeat: " + (this.configuration.isNoteRepeatActive() ? TAG_ACTIVE : "Off"));
                break;
            }
            case 79: {
                this.setPeriod(0);
                break;
            }
            case 80: {
                this.setPeriod(1);
                break;
            }
            case 71: {
                this.setPeriod(2);
                break;
            }
            case 72: {
                this.setPeriod(3);
                break;
            }
            case 63: {
                this.setPeriod(4);
                break;
            }
            case 64: {
                this.setPeriod(5);
                break;
            }
            case 55: {
                this.setPeriod(6);
                break;
            }
            case 56: {
                this.setPeriod(7);
                break;
            }
            case 81: {
                this.setNoteLength(0);
                break;
            }
            case 82: {
                this.setNoteLength(1);
                break;
            }
            case 73: {
                this.setNoteLength(2);
                break;
            }
            case 74: {
                this.setNoteLength(3);
                break;
            }
            case 65: {
                this.setNoteLength(4);
                break;
            }
            case 66: {
                this.setNoteLength(5);
                break;
            }
            case 57: {
                this.setNoteLength(6);
                break;
            }
            case 58: {
                this.setNoteLength(7);
                break;
            }
            case 88: {
                int octave = Math.max(0, this.configuration.getNoteRepeatOctave() - 1);
                this.configuration.setNoteRepeatOctave(octave);
                ((LaunchpadControlSurface)this.surface).getDisplay().notify("Note Repeat Octave Range: " + octave);
                break;
            }
            case 89: {
                int octave2 = Math.min(8, this.configuration.getNoteRepeatOctave() + 1);
                this.configuration.setNoteRepeatOctave(octave2);
                ((LaunchpadControlSurface)this.surface).getDisplay().notify("Note Repeat Octave Range: " + octave2);
                break;
            }
            case 91: {
                boolean enabled = !this.configuration.isAccentActive();
                this.configuration.setAccentEnabled(enabled);
                ((LaunchpadControlSurface)this.surface).getDisplay().notify("Fixed Accent: " + (enabled ? "On" : "Off"));
                break;
            }
            case 97: {
                this.model.getTrackBank().addChannel(ChannelType.INSTRUMENT);
                break;
            }
            case 98: {
                this.model.getTrackBank().addChannel(ChannelType.AUDIO);
                break;
            }
            case 99: {
                this.model.getApplication().addEffectTrack();
                break;
            }
            default: {
                if (((LaunchpadControlSurface)this.surface).isPro()) break;
                this.handleTransport(note);
            }
        }
    }

    private void handleTransport(int note) {
        switch (note) {
            case 92: {
                this.simulateNormalButtonPress(ButtonID.METRONOME);
                this.mvHelper.delayDisplay(() -> "Metronome: " + (this.model.getTransport().isMetronomeOn() ? "On" : "Off"));
                break;
            }
            case 93: {
                this.simulateShiftedButtonPress(ButtonID.METRONOME);
                ((LaunchpadControlSurface)this.surface).getDisplay().notify("Tap Tempo");
                break;
            }
            case 84: {
                this.simulateNormalButtonPress(ButtonID.UNDO);
                ((LaunchpadControlSurface)this.surface).getDisplay().notify("Undo");
                break;
            }
            case 85: {
                this.simulateShiftedButtonPress(ButtonID.UNDO);
                ((LaunchpadControlSurface)this.surface).getDisplay().notify("Redo");
                break;
            }
            case 76: {
                this.configuration.toggleDeleteModeActive();
                ((LaunchpadControlSurface)this.surface).getDisplay().notify("Delete " + (this.configuration.isDeleteModeActive() ? TAG_ACTIVE : "Off"));
                break;
            }
            case 77: {
                this.simulateShiftedButtonPress(ButtonID.DELETE);
                this.mvHelper.delayDisplay(() -> "Arrangement Loop: " + (this.model.getTransport().isLoop() ? "On" : "Off"));
                break;
            }
            case 69: {
                this.simulateShiftedButtonPress(ButtonID.QUANTIZE);
                break;
            }
            case 68: {
                this.simulateNormalButtonPress(ButtonID.QUANTIZE);
                ((LaunchpadControlSurface)this.surface).getDisplay().notify("Quantize");
                break;
            }
            case 60: {
                this.configuration.toggleDuplicateModeActive();
                ((LaunchpadControlSurface)this.surface).getDisplay().notify("Duplicate " + (this.configuration.isDuplicateModeActive() ? TAG_ACTIVE : "Off"));
                break;
            }
            case 61: {
                this.simulateShiftedButtonPress(ButtonID.DUPLICATE);
                ((LaunchpadControlSurface)this.surface).getDisplay().notify("Double");
                break;
            }
            case 52: {
                this.simulateNormalButtonPress(ButtonID.PLAY);
                ((LaunchpadControlSurface)this.surface).getDisplay().notify("Play");
                break;
            }
            case 53: {
                this.simulateShiftedButtonPress(ButtonID.PLAY);
                ((LaunchpadControlSurface)this.surface).getDisplay().notify("New");
                break;
            }
            case 44: {
                this.configuredRecordCommand.execute(ButtonEvent.DOWN, 127);
                this.configuredRecordCommand.execute(ButtonEvent.UP, 0);
                break;
            }
            case 45: {
                this.configuredShiftedRecordCommand.execute(ButtonEvent.DOWN, 127);
                this.configuredShiftedRecordCommand.execute(ButtonEvent.UP, 0);
                break;
            }
        }
    }

    @Override
    public int getButtonColor(ButtonID buttonID) {
        return ((LaunchpadControlSurface)this.surface).isPro() ? 0 : MODE_COLORS.get((Object)buttonID);
    }

    private void handleControlModes(ButtonID commandID) {
        ((LaunchpadControlSurface)this.surface).getButton(commandID).getCommand().execute(ButtonEvent.DOWN, 127);
    }

    @Override
    public void onButton(ButtonID buttonID, ButtonEvent event, int velocity) {
        if (((LaunchpadControlSurface)this.surface).isPro() || event != ButtonEvent.DOWN) {
            return;
        }
        ButtonID modeButton = CONTROL_MODES.get((Object)buttonID);
        if (modeButton != null) {
            this.handleControlModes(modeButton);
        }
    }

    @Override
    public void updateScrollStates(ScrollStates scrollStates) {
        scrollStates.setCanScrollLeft(true);
        scrollStates.setCanScrollRight(true);
        scrollStates.setCanScrollUp(true);
        scrollStates.setCanScrollDown(true);
    }

    private void setPeriod(int index) {
        this.configuration.setNoteRepeatPeriod(Resolution.values()[index]);
        ((LaunchpadControlSurface)this.surface).scheduleTask(() -> ((LaunchpadControlSurface)this.surface).getDisplay().notify("Period: " + Resolution.getNameAt(index)), 100L);
    }

    private void setNoteLength(int index) {
        this.configuration.setNoteRepeatLength(Resolution.values()[index]);
        ((LaunchpadControlSurface)this.surface).scheduleTask(() -> ((LaunchpadControlSurface)this.surface).getDisplay().notify("Note Length: " + Resolution.getNameAt(index)), 100L);
    }

    static {
        CONTROL_MODES.put(ButtonID.SCENE1, ButtonID.VOLUME);
        CONTROL_MODES.put(ButtonID.SCENE2, ButtonID.PAN_SEND);
        CONTROL_MODES.put(ButtonID.SCENE3, ButtonID.SENDS);
        CONTROL_MODES.put(ButtonID.SCENE4, ButtonID.TRACK);
        CONTROL_MODES.put(ButtonID.SCENE5, ButtonID.STOP_CLIP);
        CONTROL_MODES.put(ButtonID.SCENE6, ButtonID.MUTE);
        CONTROL_MODES.put(ButtonID.SCENE7, ButtonID.SOLO);
        CONTROL_MODES.put(ButtonID.SCENE8, ButtonID.REC_ARM);
        MODE_COLORS.put(ButtonID.SCENE1, 34);
        MODE_COLORS.put(ButtonID.SCENE2, 38);
        MODE_COLORS.put(ButtonID.SCENE3, 50);
        MODE_COLORS.put(ButtonID.SCENE4, 22);
        MODE_COLORS.put(ButtonID.SCENE5, 4);
        MODE_COLORS.put(ButtonID.SCENE6, 14);
        MODE_COLORS.put(ButtonID.SCENE7, 46);
        MODE_COLORS.put(ButtonID.SCENE8, 6);
    }
}

