/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.novation.launchpad.view;

import de.mossgrabers.controller.novation.launchpad.LaunchpadConfiguration;
import de.mossgrabers.controller.novation.launchpad.controller.LaunchpadControlSurface;
import de.mossgrabers.framework.controller.ButtonID;
import de.mossgrabers.framework.controller.display.IDisplay;
import de.mossgrabers.framework.controller.grid.IPadGrid;
import de.mossgrabers.framework.controller.grid.IVirtualFader;
import de.mossgrabers.framework.controller.grid.IVirtualFaderCallback;
import de.mossgrabers.framework.controller.grid.VirtualFaderImpl;
import de.mossgrabers.framework.daw.DAWColor;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.data.ISend;
import de.mossgrabers.framework.daw.data.ITrack;
import de.mossgrabers.framework.daw.data.bank.ISceneBank;
import de.mossgrabers.framework.daw.data.bank.ITrackBank;
import de.mossgrabers.framework.featuregroup.AbstractView;
import de.mossgrabers.framework.featuregroup.IScrollableView;
import de.mossgrabers.framework.utils.ButtonEvent;
import de.mossgrabers.framework.utils.ScrollStates;
import java.util.Optional;

public class MixView
extends AbstractView<LaunchpadControlSurface, LaunchpadConfiguration>
implements IVirtualFaderCallback,
IScrollableView {
    private final IVirtualFader fader;
    private FaderMode faderMode = FaderMode.VOLUME;

    public MixView(LaunchpadControlSurface surface, IModel model) {
        super("Mix", surface, model);
        this.fader = new VirtualFaderImpl(model.getHost(), this);
    }

    @Override
    public void drawGrid() {
        IPadGrid padGrid = ((LaunchpadControlSurface)this.surface).getPadGrid();
        ITrackBank tb = this.model.getCurrentTrackBank();
        for (int i = 0; i < 8; ++i) {
            ITrack track = (ITrack)tb.getItem(i);
            if (track.doesExist()) {
                boolean isSelected = track.isSelected();
                boolean hasSends = track.getSendBank().getItemCount() > 0;
                padGrid.light(92 + i, this.colorManager.getColorIndex(DAWColor.getColorID(track.getColor())));
                padGrid.light(84 + i, isSelected ? 37 : 1);
                int send1ColorID = hasSends ? (isSelected ? 49 : 1) : 0;
                padGrid.light(76 + i, send1ColorID);
                int send2ColorID = hasSends ? (isSelected ? 17 : 1) : 0;
                padGrid.light(68 + i, send2ColorID);
                padGrid.light(60 + i, ((LaunchpadControlSurface)this.surface).isPressed(ButtonID.get(ButtonID.PAD25, i)) ? 6 : 4);
                padGrid.light(52 + i, track.isMute() ? 1 : 13);
                padGrid.light(44 + i, track.isSolo() ? 45 : 117);
                padGrid.light(36 + i, track.isRecArm() ? 5 : 1);
                continue;
            }
            padGrid.light(92 + i, 0);
            padGrid.light(84 + i, 0);
            padGrid.light(76 + i, 0);
            padGrid.light(68 + i, 0);
            padGrid.light(60 + i, 0);
            padGrid.light(52 + i, 0);
            padGrid.light(44 + i, 0);
            padGrid.light(36 + i, 0);
        }
    }

    @Override
    public void onGridNote(int note, int velocity) {
        if (velocity == 0) {
            return;
        }
        int n = note - 36;
        int index = n % 8;
        int what = n / 8;
        ITrack track = (ITrack)this.model.getCurrentTrackBank().getItem(index);
        IDisplay display = ((LaunchpadControlSurface)this.surface).getDisplay();
        switch (what) {
            case 7: {
                this.faderMode = FaderMode.VOLUME;
                display.notify("Volume");
                this.selectTrack(track);
                break;
            }
            case 6: {
                this.faderMode = FaderMode.PAN;
                display.notify("Panning");
                this.selectTrack(track);
                break;
            }
            case 5: {
                this.faderMode = FaderMode.SEND1;
                ISend send1 = (ISend)track.getSendBank().getItem(0);
                display.notify("Send 1: " + (send1.doesExist() ? send1.getName() : "None"));
                this.selectTrack(track);
                break;
            }
            case 4: {
                this.faderMode = FaderMode.SEND2;
                ISend send2 = (ISend)track.getSendBank().getItem(1);
                display.notify("Send 2: " + (send2.doesExist() ? send2.getName() : "None"));
                this.selectTrack(track);
                break;
            }
            case 3: {
                track.stop(false);
                display.notify("Stop clip");
                break;
            }
            case 2: {
                track.toggleMute();
                display.notify("Mute");
                break;
            }
            case 1: {
                track.toggleSolo();
                display.notify("Solo");
                break;
            }
            case 0: {
                track.toggleRecArm();
                display.notify("Rec Arm");
                break;
            }
        }
    }

    @Override
    public int getButtonColor(ButtonID buttonID) {
        int index = 7 - (buttonID.ordinal() - ButtonID.SCENE1.ordinal());
        int color = 0;
        int value = 0;
        Optional track = this.model.getCurrentTrackBank().getSelectedItem();
        if (track.isPresent()) {
            switch (this.faderMode.ordinal()) {
                default: {
                    value = ((ITrack)track.get()).getVolume();
                    color = 34;
                    break;
                }
                case 1: {
                    value = ((ITrack)track.get()).getPan();
                    color = 37;
                    break;
                }
                case 2: {
                    ISend send1 = (ISend)((ITrack)track.get()).getSendBank().getItem(0);
                    value = send1.doesExist() ? send1.getValue() : 0;
                    color = 49;
                    break;
                }
                case 3: {
                    ISend send2 = (ISend)((ITrack)track.get()).getSendBank().getItem(1);
                    value = send2.doesExist() ? send2.getValue() : 0;
                    color = 17;
                }
            }
        }
        this.fader.setup(color, this.faderMode == FaderMode.PAN);
        this.fader.setValue(value);
        return this.fader.getColorState(index);
    }

    @Override
    public void onButton(ButtonID buttonID, ButtonEvent event, int velocity) {
        if (!ButtonID.isSceneButton(buttonID) || event != ButtonEvent.DOWN) {
            return;
        }
        Optional track = this.model.getCurrentTrackBank().getSelectedItem();
        if (track.isEmpty()) {
            return;
        }
        int index = buttonID.ordinal() - ButtonID.SCENE1.ordinal();
        this.fader.moveTo(7 - index, velocity);
    }

    @Override
    public int getValue() {
        Optional trackOpt = this.model.getCurrentTrackBank().getSelectedItem();
        if (trackOpt.isEmpty()) {
            return 0;
        }
        ITrack track = (ITrack)trackOpt.get();
        switch (this.faderMode.ordinal()) {
            default: {
                return track.getVolume();
            }
            case 1: {
                return track.getPan();
            }
            case 2: {
                ISend send1 = (ISend)track.getSendBank().getItem(0);
                return send1.doesExist() ? send1.getValue() : 0;
            }
            case 3: 
        }
        ISend send2 = (ISend)track.getSendBank().getItem(1);
        return send2.doesExist() ? send2.getValue() : 0;
    }

    @Override
    public void setValue(int value) {
        Optional track = this.model.getCurrentTrackBank().getSelectedItem();
        if (track.isEmpty()) {
            return;
        }
        switch (this.faderMode.ordinal()) {
            default: {
                ((ITrack)track.get()).getVolumeParameter().setValueImmediatly(value);
                break;
            }
            case 1: {
                ((ITrack)track.get()).getPanParameter().setValueImmediatly(value);
                break;
            }
            case 2: {
                ISend send1 = (ISend)((ITrack)track.get()).getSendBank().getItem(0);
                if (!send1.doesExist()) break;
                send1.setValueImmediatly(value);
                break;
            }
            case 3: {
                ISend send2 = (ISend)((ITrack)track.get()).getSendBank().getItem(1);
                if (!send2.doesExist()) break;
                send2.setValueImmediatly(value);
            }
        }
    }

    @Override
    public void updateScrollStates(ScrollStates scrollStates) {
        ITrackBank tb = this.model.getCurrentTrackBank();
        Optional sel = tb.getSelectedItem();
        int selIndex = sel.isPresent() ? ((ITrack)sel.get()).getIndex() : -1;
        ISceneBank sceneBank = tb.getSceneBank();
        scrollStates.setCanScrollLeft(selIndex > 0 || tb.canScrollPageBackwards());
        scrollStates.setCanScrollRight(selIndex >= 0 && selIndex < 7 && ((ITrack)tb.getItem(selIndex + 1)).doesExist() || tb.canScrollPageForwards());
        scrollStates.setCanScrollUp(sceneBank.canScrollPageBackwards());
        scrollStates.setCanScrollDown(sceneBank.canScrollPageForwards());
    }

    private void selectTrack(ITrack track) {
        if (track.isSelected()) {
            return;
        }
        track.select();
        ((LaunchpadControlSurface)this.surface).getDisplay().notify(track.getPosition() + 1 + ": " + track.getName());
    }

    private static enum FaderMode {
        VOLUME,
        PAN,
        SEND1,
        SEND2;

    }
}

