/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.ni.maschine.mk3.view;

import de.mossgrabers.controller.ni.maschine.mk3.MaschineConfiguration;
import de.mossgrabers.controller.ni.maschine.mk3.controller.MaschineControlSurface;
import de.mossgrabers.controller.ni.maschine.mk3.view.IExecuteFunction;
import de.mossgrabers.framework.controller.display.IDisplay;
import de.mossgrabers.framework.controller.grid.IPadGrid;
import de.mossgrabers.framework.daw.IApplication;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.clip.INoteClip;
import de.mossgrabers.framework.utils.ButtonEvent;
import de.mossgrabers.framework.view.AbstractShiftView;

public class ShiftView
extends AbstractShiftView<MaschineControlSurface, MaschineConfiguration>
implements IExecuteFunction {
    public ShiftView(MaschineControlSurface surface, IModel model) {
        super("Shift", surface, model);
    }

    @Override
    public void onGridNote(int note, int velocity) {
        if (velocity == 0) {
            return;
        }
        this.setWasUsed();
        this.executeFunction(note - 36, ButtonEvent.DOWN);
    }

    @Override
    public void executeFunction(int padIndex, ButtonEvent buttonEvent) {
        if (buttonEvent != ButtonEvent.DOWN) {
            return;
        }
        IDisplay display = ((MaschineControlSurface)this.surface).getDisplay();
        INoteClip clip = this.model.getCursorClip();
        ((MaschineControlSurface)this.surface).setStopConsumed();
        if (padIndex == 0 || padIndex == 1) {
            IApplication application = this.model.getApplication();
            if (padIndex == 0) {
                application.undo();
                display.notify("Undo");
            } else {
                application.redo();
                display.notify("Redo");
            }
        }
        if (clip.doesExist() && clip instanceof INoteClip) {
            INoteClip noteClip = clip;
            switch (padIndex) {
                case 4: {
                    clip.quantize(1.0);
                    display.notify("Quantize: 100%");
                    break;
                }
                case 5: {
                    clip.quantize(0.5);
                    display.notify("Quantize: 50%");
                    break;
                }
                case 8: {
                    noteClip.clearAll();
                    display.notify("Clear all notes");
                    break;
                }
                case 12: {
                    noteClip.transpose(-1);
                    display.notify("Transpose: -1");
                    break;
                }
                case 13: {
                    noteClip.transpose(1);
                    display.notify("Transpose: 1");
                    break;
                }
                case 14: {
                    noteClip.transpose(-12);
                    display.notify("Transpose: -12");
                    break;
                }
                case 15: {
                    noteClip.transpose(12);
                    display.notify("Transpose: 12");
                    break;
                }
            }
        }
    }

    @Override
    public void drawGrid() {
        INoteClip clip = this.model.getCursorClip();
        boolean exists = clip.doesExist() && clip instanceof INoteClip;
        IPadGrid padGrid = ((MaschineControlSurface)this.surface).getPadGrid();
        padGrid.lightEx(0, 0, exists ? 31 : 0);
        padGrid.lightEx(1, 0, exists ? 31 : 0);
        padGrid.lightEx(2, 0, exists ? 31 : 0);
        padGrid.lightEx(3, 0, exists ? 31 : 0);
        padGrid.lightEx(0, 1, exists ? 14 : 0);
        padGrid.lightEx(1, 1, 0);
        padGrid.lightEx(2, 1, 0);
        padGrid.lightEx(3, 1, 0);
        padGrid.lightEx(0, 2, exists ? 22 : 0);
        padGrid.lightEx(1, 2, exists ? 22 : 0);
        padGrid.lightEx(2, 2, 0);
        padGrid.lightEx(3, 2, 0);
        padGrid.lightEx(0, 3, 6);
        padGrid.lightEx(1, 3, 22);
        padGrid.lightEx(2, 3, 0);
        padGrid.lightEx(3, 3, 0);
    }
}

