/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.ni.maschine.jam.controller;

import de.mossgrabers.controller.ni.maschine.Maschine;
import de.mossgrabers.controller.ni.maschine.core.AbstractMaschineControlSurface;
import de.mossgrabers.controller.ni.maschine.core.controller.MaschinePadGrid;
import de.mossgrabers.controller.ni.maschine.jam.MaschineJamConfiguration;
import de.mossgrabers.controller.ni.maschine.jam.controller.FaderConfig;
import de.mossgrabers.framework.controller.color.ColorManager;
import de.mossgrabers.framework.controller.grid.IPadGrid;
import de.mossgrabers.framework.daw.IHost;
import de.mossgrabers.framework.daw.midi.IMidiInput;
import de.mossgrabers.framework.daw.midi.IMidiOutput;

public class MaschineJamControlSurface
extends AbstractMaschineControlSurface<MaschineJamConfiguration> {
    public static final int FOOTSWITCH_TIP = 3;
    public static final int FOOTSWITCH_RING = 4;
    public static final int FADER1 = 8;
    public static final int FADER2 = 9;
    public static final int FADER3 = 10;
    public static final int FADER4 = 11;
    public static final int FADER5 = 12;
    public static final int FADER6 = 13;
    public static final int FADER7 = 14;
    public static final int FADER8 = 15;
    public static final int FADER_TOUCH1 = 20;
    public static final int FADER_TOUCH2 = 21;
    public static final int FADER_TOUCH3 = 22;
    public static final int FADER_TOUCH4 = 23;
    public static final int FADER_TOUCH5 = 24;
    public static final int FADER_TOUCH6 = 25;
    public static final int FADER_TOUCH7 = 26;
    public static final int FADER_TOUCH8 = 27;
    public static final int SONG = 30;
    public static final int STEP = 31;
    public static final int PAD_MODE = 32;
    public static final int CLEAR = 33;
    public static final int DUPLICATE = 34;
    public static final int NOTE_REPEAT = 35;
    public static final int MACRO = 36;
    public static final int LEVEL = 37;
    public static final int AUX = 38;
    public static final int CONTROL = 39;
    public static final int AUTO = 40;
    public static final int NAV_UP = 41;
    public static final int NAV_DOWN = 42;
    public static final int NAV_LEFT = 43;
    public static final int NAV_RIGHT = 44;
    public static final int SELECT = 50;
    public static final int SWING = 51;
    public static final int TUNE = 52;
    public static final int LOCK = 53;
    public static final int NOTES = 54;
    public static final int PERFORM = 55;
    public static final int BROWSE = 56;
    public static final int KNOB_TURN = 57;
    public static final int KNOB_PUSH = 58;
    public static final int KNOB_TOUCH = 59;
    public static final int IN = 60;
    public static final int HEADPHONE = 61;
    public static final int MASTER = 62;
    public static final int GROUP = 63;
    public static final int STRIP_LEFT = 64;
    public static final int STRIP_RIGHT = 65;
    public static final int FOOTSWITCH = 66;
    public static final int GROUP_A = 70;
    public static final int GROUP_B = 71;
    public static final int GROUP_C = 72;
    public static final int GROUP_D = 73;
    public static final int GROUP_E = 74;
    public static final int GROUP_F = 75;
    public static final int GROUP_G = 76;
    public static final int GROUP_H = 77;
    public static final int SCENE1 = 80;
    public static final int SCENE2 = 81;
    public static final int SCENE3 = 82;
    public static final int SCENE4 = 83;
    public static final int SCENE5 = 84;
    public static final int SCENE6 = 85;
    public static final int SCENE7 = 86;
    public static final int SCENE8 = 87;
    public static final int PLAY = 90;
    public static final int RECORD = 91;
    public static final int LEFT = 92;
    public static final int RIGHT = 93;
    public static final int TEMPO = 94;
    public static final int GRID = 95;
    public static final int SOLO = 96;
    public static final int MUTE = 97;
    private static final int STRIP_VALUE_OFFSET = 11;
    private static final byte[] STRIP_SETUP = new byte[]{-16, 0, 33, 9, 21, 0, 77, 80, 0, 1, 5, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -9};
    private static final byte[] STRIP_DUAL_VALUE = new byte[]{-16, 0, 33, 9, 21, 0, 77, 80, 0, 1, 4, 0, 0, 0, 0, 0, 0, 0, 0, -9};
    private static final FaderConfig[] EMPTY = new FaderConfig[8];
    private final FaderConfig[] currentFaderConfigs = new FaderConfig[8];

    public MaschineJamControlSurface(IHost host, ColorManager colorManager, MaschineJamConfiguration configuration, IMidiOutput output, IMidiInput input) {
        super(host, configuration, colorManager, Maschine.JAM, output, input, (IPadGrid)new MaschinePadGrid(colorManager, output, 8, 8), 800.0, 800.0);
        for (int i = 0; i < this.currentFaderConfigs.length; ++i) {
            this.currentFaderConfigs[i] = new FaderConfig(-1, -1, -1);
        }
    }

    @Override
    protected void flushHardware() {
        super.flushHardware();
        ((MaschinePadGrid)this.padGrid).flush();
    }

    @Override
    protected void internalShutdown() {
        this.setupFaders(EMPTY);
        super.internalShutdown();
    }

    public void setupFaders(FaderConfig[] configurations) {
        byte[] stripSetup = (byte[])STRIP_SETUP.clone();
        byte[] stripDualValues = (byte[])STRIP_DUAL_VALUE.clone();
        boolean hasSetupChanged = false;
        boolean hasDualValueChanged = false;
        for (int i = 0; i < 8; ++i) {
            boolean isDual;
            FaderConfig faderConfig = configurations[i];
            FaderConfig currentFaderConfig = this.currentFaderConfigs[i];
            boolean bl = isDual = faderConfig.getType() == 3;
            if (faderConfig.getType() != currentFaderConfig.getType() || faderConfig.getColor() != currentFaderConfig.getColor()) {
                hasSetupChanged = true;
            }
            int pos = i * 2;
            stripSetup[11 + pos] = (byte)faderConfig.getType();
            stripSetup[12 + pos] = (byte)faderConfig.getColor();
            if (isDual && (faderConfig.getDualValue() != currentFaderConfig.getDualValue() || hasSetupChanged)) {
                hasDualValueChanged = true;
            }
            if (faderConfig.getValue() != currentFaderConfig.getValue() || hasSetupChanged) {
                this.output.sendCC(8 + i, faderConfig.getValue());
            }
            stripDualValues[11 + i] = (byte)Math.max(0, faderConfig.getDualValue());
            this.currentFaderConfigs[i] = faderConfig;
        }
        if (hasSetupChanged) {
            this.output.sendSysex(stripSetup);
        }
        if (hasDualValueChanged) {
            this.output.sendSysex(stripDualValues);
        }
    }

    static {
        for (int i = 0; i < EMPTY.length; ++i) {
            MaschineJamControlSurface.EMPTY[i] = new FaderConfig(0, 0, 0);
        }
    }
}

