/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.ni.kontrol.mkii.controller;

import de.mossgrabers.controller.ni.kontrol.mkii.KontrolProtocolConfiguration;
import de.mossgrabers.controller.ni.kontrol.mkii.NIHIASysExCallback;
import de.mossgrabers.controller.ni.kontrol.mkii.mode.ParamsMode;
import de.mossgrabers.framework.controller.AbstractControlSurface;
import de.mossgrabers.framework.controller.color.ColorManager;
import de.mossgrabers.framework.controller.hardware.BindType;
import de.mossgrabers.framework.daw.IHost;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.midi.IMidiInput;
import de.mossgrabers.framework.daw.midi.IMidiOutput;
import de.mossgrabers.framework.mode.Modes;
import de.mossgrabers.framework.utils.StringUtils;
import java.util.Arrays;
import java.util.Map;
import java.util.TreeMap;

public class KontrolProtocolControlSurface
extends AbstractControlSurface<KontrolProtocolConfiguration> {
    public static final int SYSEX_SURFACE_CONFIGURATION = 3;
    public static final int SYSEX_IDENTITY = 7;
    public static final int SYSEX_SET_TEMPO = 25;
    public static final int SYSEX_TRACK_AVAILABLE = 64;
    public static final int SYSEX_TRACK_INSTANCE = 65;
    public static final int SYSEX_TRACK_SELECTED = 66;
    public static final int SYSEX_TRACK_MUTE = 67;
    public static final int SYSEX_TRACK_SOLO = 68;
    public static final int SYSEX_TRACK_RECARM = 69;
    public static final int SYSEX_TRACK_VOLUME_TEXT = 70;
    public static final int SYSEX_TRACK_PAN_TEXT = 71;
    public static final int SYSEX_TRACK_NAME = 72;
    public static final int SYSEX_TRACK_VU = 73;
    public static final int SYSEX_TRACK_MUTED_BY_SOLO = 74;
    public static final int SYSEX_TRACK_COLOR = 75;
    public static final int SYSEX_PLUGIN_SELECTED_PLUGIN = 112;
    public static final int SYSEX_PLUGIN_CHAIN_INFO = 113;
    public static final int SYSEX_PLUGIN_PARAM_DISPLAY_NAME = 114;
    public static final int SYSEX_PLUGIN_PARAM_DISPLAY_VALUE = 115;
    public static final int SYSEX_PLUGIN_SELECTED_PARAM_PAGE = 116;
    public static final int SYSEX_PLUGIN_PAGE_NAME = 117;
    public static final int SYSEX_PLUGIN_SELECTED_PRESET = 118;
    public static final int CC_HELLO = 1;
    public static final int CC_GOODBYE = 2;
    public static final int CC_SHIFT = 4;
    public static final int CC_MODE_SELECT = 5;
    public static final int CC_USE_SYSEX_PARAM_UPDATES = 6;
    public static final int CC_PLAY = 16;
    public static final int CC_RESTART = 17;
    public static final int CC_RECORD = 18;
    public static final int CC_COUNT_IN = 19;
    public static final int CC_STOP = 20;
    public static final int CC_CLEAR = 21;
    public static final int CC_LOOP = 22;
    public static final int CC_METRO = 23;
    public static final int CC_TAP_TEMPO = 24;
    public static final int CC_UNDO = 32;
    public static final int CC_REDO = 33;
    public static final int CC_QUANTIZE = 34;
    public static final int CC_AUTOMATION = 35;
    public static final int CC_NAVIGATE_TRACKS = 48;
    public static final int CC_NAVIGATE_BANKS = 49;
    public static final int CC_NAVIGATE_CLIPS = 50;
    public static final int CC_NAVIGATE_MOVE_TRANSPORT = 52;
    public static final int CC_NAVIGATE_MOVE_LOOP = 53;
    public static final int CC_NAVIGATE_PRESETS = 54;
    public static final int CC_TRACK_VOLUME = 80;
    public static final int CC_TRACK_PAN = 88;
    public static final int CC_PLAY_SELECTED_CLIP = 96;
    public static final int CC_STOP_CLIP = 97;
    public static final int CC_PLAY_SCENE = 98;
    public static final int CC_RECORD_SESSION = 99;
    public static final int CC_CHANGE_SELECTED_TRACK_VOLUME = 100;
    public static final int CC_CHANGE_SELECTED_TRACK_PAN = 101;
    public static final int CC_SELECTED_TRACK_MUTE = 102;
    public static final int CC_SELECTED_TRACK_SOLO = 103;
    public static final int CC_SELECTED_TRACK_AVAILABLE = 104;
    public static final int CC_SELECTED_TRACK_MUTED_BY_SOLO = 105;
    public static final int CC_PARAM_VALUE_CHANGE = 112;
    private static final double TEN_NS_PER_MINUTE = 6.0E9;
    private static final byte[] NHIA_SYSEX_HEADER = new byte[]{-16, 0, 33, 9, 0, 0, 68, 67, 1, 0};
    private final int requiredVersion;
    private int protocolVersion = 4;
    private final NIHIASysExCallback sysexCallback;
    private final Object cacheLock = new Object();
    private final ValueCache valueCache = new ValueCache();
    private double cachedTempo = 0.0;
    private final Object handshakeLock = new Object();
    private boolean isConnectedToNIHIA = false;
    private int[] ccValueCache = new int[255];

    public KontrolProtocolControlSurface(IHost host, ColorManager colorManager, KontrolProtocolConfiguration configuration, IMidiOutput output, IMidiInput input, NIHIASysExCallback sysexCallback, int version) {
        super(host, configuration, colorManager, output, input, null, 800.0, 300.0);
        this.requiredVersion = version;
        this.defaultMidiChannel = 15;
        this.sysexCallback = sysexCallback;
        input.setSysexCallback(this::handleSysEx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void internalShutdown() {
        super.internalShutdown();
        Object object = this.handshakeLock;
        synchronized (object) {
            this.isConnectedToNIHIA = false;
            for (int i = 0; i < 8; ++i) {
                this.sendKontrolSysEx(64, 0, i);
            }
            this.sendCommand(2, 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isConnectedToNIHIA() {
        Object object = this.handshakeLock;
        synchronized (object) {
            return this.isConnectedToNIHIA;
        }
    }

    public void initHandshake() {
        this.sendCommand(1, this.requiredVersion);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handshakeSuccess(int protocol) {
        Object object = this.handshakeLock;
        synchronized (object) {
            this.setProtocolVersion(protocol);
            this.clearCache();
            this.isConnectedToNIHIA = true;
        }
        this.sysexCallback.sendDAWInfo();
    }

    @Override
    public void setTrigger(BindType bindType, int channel, int cc, int value) {
        this.sendCommand(cc, value);
    }

    public void sendCommand(int command, int value) {
        if (this.ccValueCache[command] == value) {
            return;
        }
        this.ccValueCache[command] = value;
        this.output.sendCCEx(15, command, value);
    }

    public void sendKontrolSysEx(int stateID, int value, int index, boolean doCache) {
        this.sendKontrolSysEx(stateID, value, index, "", doCache);
    }

    public void sendKontrolSysEx(int stateID, int value, int index) {
        this.sendKontrolSysEx(stateID, value, index, "", true);
    }

    public void sendKontrolSysEx(int stateID, int value, int index, String info, boolean doCache) {
        this.sendKontrolSysEx(stateID, value, index, StringUtils.fixASCII(info).chars().toArray(), doCache);
    }

    public void sendKontrolSysEx(int stateID, int value, int index, String info) {
        this.sendKontrolSysEx(stateID, value, index, StringUtils.fixASCII(info).chars().toArray(), true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendKontrolSysEx(int stateID, int value, int index, int[] info, boolean doCache) {
        Object object = this.cacheLock;
        synchronized (object) {
            boolean isPresent = this.valueCache.store(stateID, index, value, info);
            if (doCache && isPresent) {
                return;
            }
        }
        byte[] data = new byte[3 + info.length];
        data[0] = (byte)stateID;
        data[1] = (byte)value;
        data[2] = (byte)index;
        for (int i = 0; i < info.length; ++i) {
            data[3 + i] = (byte)info[i];
        }
        this.sendNHIASysEx(data);
    }

    public void sendKontrolSysEx(int stateID, int value, int index, int[] info) {
        this.sendKontrolSysEx(stateID, value, index, info, true);
    }

    public void sendGlobalValues(IModel model) {
        if (this.protocolVersion < 4) {
            return;
        }
        this.sendTempo(model.getTransport().getTempo(), false);
        ((ParamsMode)this.getModeManager().get(Modes.DEVICE_PARAMS)).updateAvailableDevices();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendTempo(double tempo, boolean ignoreCache) {
        Object object = this.cacheLock;
        synchronized (object) {
            if (!ignoreCache && Double.compare(tempo, this.cachedTempo) == 0) {
                return;
            }
            this.cachedTempo = tempo;
        }
        byte[] data = new byte[8];
        data[0] = 25;
        data[1] = 0;
        data[2] = 0;
        long nsPerMinute = (long)(6.0E9 / tempo);
        for (int i = 0; i < 5; ++i) {
            data[3 + i] = (byte)(nsPerMinute >> i * 7 & 0x7FL);
        }
        this.sendNHIASysEx(data);
    }

    public void sendDAWInfo(int versionMajor, int versionMinor, String dawName) {
        int[] array = StringUtils.fixASCII(dawName).chars().toArray();
        byte[] data = new byte[3 + array.length];
        data[0] = 7;
        data[1] = (byte)versionMajor;
        data[2] = (byte)versionMinor;
        for (int i = 0; i < array.length; ++i) {
            data[3 + i] = (byte)array[i];
        }
        this.sendNHIASysEx(data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearCache() {
        Object object = this.cacheLock;
        synchronized (object) {
            this.valueCache.clearCache();
            Arrays.fill(this.ccValueCache, -1);
        }
        super.clearCache();
    }

    private void sendNHIASysEx(byte[] data) {
        super.sendSysex(NHIA_SYSEX_HEADER, data);
    }

    private void handleSysEx(String data) {
        int[] byteData = StringUtils.fromHexStr(data);
        if (!KontrolProtocolControlSurface.startsWithPrefix(byteData)) {
            this.host.error(String.format("Unused sysex command: %s", data));
            return;
        }
        switch (byteData[10]) {
            case 25: {
                long nsPerMinute = 0L;
                for (int i = 0; i < 5; ++i) {
                    nsPerMinute |= (long)byteData[13 + i] << i * 7;
                }
                double tempo = 6.0E9 / (double)nsPerMinute;
                long roundedTo2Fractions = Math.round(tempo * 100.0);
                this.sysexCallback.setTempo((double)roundedTo2Fractions / 100.0);
                break;
            }
            case 112: {
                this.sysexCallback.selectDevice(byteData[12]);
                break;
            }
            default: {
                this.host.error(String.format("Unused NHIA sysex command: %02X", byteData[10]));
            }
        }
    }

    private static boolean startsWithPrefix(int[] byteData) {
        if (byteData.length < NHIA_SYSEX_HEADER.length) {
            return false;
        }
        for (int i = 0; i < NHIA_SYSEX_HEADER.length; ++i) {
            if ((byteData[i] & 0xFF) == (NHIA_SYSEX_HEADER[i] & 0xFF)) continue;
            return false;
        }
        return true;
    }

    public int getProtocolVersion() {
        return this.protocolVersion;
    }

    public void setProtocolVersion(int protocolVersion) {
        this.protocolVersion = protocolVersion;
    }

    private static class ValueCache {
        private final Map<Integer, Map<Integer, int[]>> cache = new TreeMap<Integer, Map<Integer, int[]>>();
        private int numParameterPages = -1;
        private int selectedParameterPage = -1;

        private ValueCache() {
        }

        public final void clearCache() {
            this.cache.clear();
        }

        public boolean store(int key1, int key2, int value, int[] data) {
            if (key1 == 116) {
                if (key2 != this.selectedParameterPage || value != this.numParameterPages) {
                    this.selectedParameterPage = key2;
                    this.numParameterPages = value;
                    return false;
                }
                return true;
            }
            Map item = this.cache.computeIfAbsent(key1, key -> new TreeMap());
            int[] values = (int[])item.get(key2);
            int[] newValues = new int[1 + data.length];
            newValues[0] = value;
            if (data.length > 0) {
                System.arraycopy(data, 0, newValues, 1, data.length);
            }
            if (Arrays.equals(values, newValues)) {
                return true;
            }
            item.put(key2, newValues);
            return false;
        }
    }
}

