/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.akai.fire.command.trigger;

import de.mossgrabers.controller.akai.fire.FireConfiguration;
import de.mossgrabers.controller.akai.fire.command.trigger.AbstractFireViewMultiSelectCommand;
import de.mossgrabers.controller.akai.fire.controller.FireControlSurface;
import de.mossgrabers.framework.controller.ButtonID;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.data.ICursorTrack;
import de.mossgrabers.framework.featuregroup.ModeManager;
import de.mossgrabers.framework.featuregroup.ViewManager;
import de.mossgrabers.framework.mode.INoteEditor;
import de.mossgrabers.framework.mode.INoteEditorMode;
import de.mossgrabers.framework.mode.Modes;
import de.mossgrabers.framework.utils.ButtonEvent;
import de.mossgrabers.framework.view.Views;

public class StepSequencerSelectCommand
extends AbstractFireViewMultiSelectCommand {
    public StepSequencerSelectCommand(IModel model, FireControlSurface surface) {
        super(model, surface, Views.SEQUENCER, Views.POLY_SEQUENCER);
    }

    @Override
    public void executeNormal(ButtonEvent event) {
        Views preferredView;
        if (event != ButtonEvent.UP) {
            return;
        }
        ModeManager modeManager = ((FireControlSurface)this.surface).getModeManager();
        if (((FireControlSurface)this.surface).isPressed(ButtonID.ALT)) {
            if (modeManager.isActive(new Modes[]{Modes.NOTE})) {
                modeManager.restore();
            } else {
                modeManager.setActive(Modes.NOTE);
            }
            ((FireControlSurface)this.surface).getDisplay().notify("Edit Notes: " + (modeManager.isActive(new Modes[]{Modes.NOTE}) ? "On" : "Off"));
            this.getNoteEditor().clearNotes();
            return;
        }
        this.getNoteEditor().clearNotes();
        ICursorTrack cursorTrack = this.model.getCursorTrack();
        boolean doesExist = cursorTrack.doesExist();
        int position = cursorTrack.getPosition();
        ViewManager viewManager = ((FireControlSurface)this.surface).getViewManager();
        if (viewManager.isActive(new Views[]{Views.SESSION, Views.MIX}) && doesExist && (preferredView = viewManager.getPreferredView(position)) != null && this.viewIds.contains((Object)preferredView)) {
            viewManager.setActive(preferredView);
            return;
        }
        super.executeNormal(event);
        if (doesExist) {
            viewManager.setPreferredView(position, (Views)((Object)viewManager.getActiveID()));
        }
    }

    private INoteEditor getNoteEditor() {
        return ((INoteEditorMode)((FireControlSurface)this.surface).getModeManager().get(Modes.NOTE)).getNoteEditor();
    }

    @Override
    public void executeShifted(ButtonEvent event) {
        FireConfiguration configuration;
        if (event != ButtonEvent.DOWN) {
            return;
        }
        configuration.setAccentEnabled(!(configuration = (FireConfiguration)((FireControlSurface)this.surface).getConfiguration()).isAccentActive());
    }
}

